"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = DefaultEditor;
require("./index.scss");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/kibana-utils-plugin/public");
var _sidebar = require("./components/sidebar");
var _editor_size = require("./editor_size");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const localStorage = new _public2.Storage(window.localStorage);
function DefaultEditor({
  core,
  data,
  vis,
  uiState,
  timeRange,
  filters,
  query,
  embeddableHandler,
  eventEmitter,
  linked,
  savedSearch
}) {
  const visRef = (0, _react.useRef)(null);
  const [isCollapsed, setIsCollapsed] = (0, _react.useState)(false);
  const onClickCollapse = (0, _react.useCallback)(() => {
    setIsCollapsed(value => !value);
  }, []);

  /**
   * The empty callback is in place to prevent resetting the dragging state of the resize button.
   * The mouseLeave is triggered since a visualization is rendered through another call of "ReactDOM.render()"" in expressions,
   * using the "visRef" node reference.
   * Here is the existing React issue: https://github.com/facebook/react/issues/17064
   */
  const onEditorMouseLeave = (0, _react.useCallback)(() => {}, []);
  (0, _react.useEffect)(() => {
    if (!visRef.current) {
      return;
    }
    embeddableHandler.render(visRef.current).then(() => {
      setTimeout(async () => {
        eventEmitter.emit('embeddableRendered');
      });
    });
    return () => embeddableHandler.destroy();
  }, [embeddableHandler, eventEmitter]);
  (0, _react.useEffect)(() => {
    embeddableHandler.updateInput({
      timeRange,
      filters,
      query
    });
  }, [embeddableHandler, timeRange, filters, query]);
  const editorInitialWidth = (0, _editor_size.getInitialWidth)(vis.type.editorConfig.defaultSize);
  return /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, core, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: {
      appName: 'vis_default_editor',
      storage: localStorage,
      data,
      ...core
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiResizableContainer, {
    className: "visEditor--default",
    onMouseLeave: onEditorMouseLeave
  }, (EuiResizablePanel, EuiResizableButton) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(EuiResizablePanel, {
    className: "visEditor__visualization",
    initialSize: 100 - editorInitialWidth,
    minSize: "25%",
    paddingSize: "none",
    wrapperProps: {
      className: `visEditor__visualization__wrapper ${isCollapsed ? 'visEditor__visualization__wrapper-expanded' : ''}`
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "visEditor__canvas",
    ref: visRef,
    "data-shared-items-container": true
  })), /*#__PURE__*/_react.default.createElement(EuiResizableButton, {
    alignIndicator: "start",
    className: `visEditor__resizer ${isCollapsed ? 'visEditor__resizer-isHidden' : ''}`
  }), /*#__PURE__*/_react.default.createElement(EuiResizablePanel, {
    initialSize: editorInitialWidth,
    minSize: isCollapsed ? '0' : '350px',
    paddingSize: "none",
    wrapperProps: {
      className: `visEditor__collapsibleSidebar ${isCollapsed ? 'visEditor__collapsibleSidebar-isClosed' : ''}`
    }
  }, /*#__PURE__*/_react.default.createElement(_sidebar.DefaultEditorSideBar, {
    embeddableHandler: embeddableHandler,
    isCollapsed: isCollapsed,
    onClickCollapse: onClickCollapse,
    vis: vis,
    uiState: uiState,
    isLinkedSearch: linked,
    savedSearch: savedSearch,
    timeRange: timeRange,
    eventEmitter: eventEmitter
  }))))));
}

// default export required for React.Lazy
// eslint-disable-next-line import/no-default-export
module.exports = exports.default;