"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.URLSearch = URLSearch;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/exploratory-view-plugin/public");
var _use_url_params = require("../../../../../context/url_params_context/use_url_params");
var _translations = require("../../translations");
var _key_ux_metrics = require("../../ux_metrics/key_ux_metrics");
var _translations2 = require("../../ux_metrics/translations");
var _render_option = require("./render_option");
var _use_url_search = require("./use_url_search");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const formatOptions = (urlItems, includedUrls, excludedUrls, percentile) => {
  const percTitle = (0, _translations2.getPercentileLabel)(percentile);
  return urlItems.map(item => ({
    label: item.url,
    title: item.url,
    key: item.url,
    meta: [_translations.I18LABELS.pageViews + ': ' + item.count, _translations.I18LABELS.pageLoadDuration + ': ' + (0, _key_ux_metrics.formatToSec)(item.pld) + ` (${percTitle})`],
    url: item.url,
    checked: includedUrls !== null && includedUrls !== void 0 && includedUrls.includes(item.url) ? 'on' : excludedUrls !== null && excludedUrls !== void 0 && excludedUrls.includes(item.url) ? 'off' : undefined
  }));
};
const processItems = items => {
  const includedItems = (0, _lodash.map)(items.filter(({
    checked,
    isWildcard
  }) => checked === 'on' && !isWildcard), 'label');
  const excludedItems = (0, _lodash.map)(items.filter(({
    checked,
    isWildcard
  }) => checked === 'off' && !isWildcard), 'label');
  const includedWildcards = (0, _lodash.map)(items.filter(({
    checked,
    isWildcard
  }) => checked === 'on' && isWildcard), 'title');
  const excludedWildcards = (0, _lodash.map)(items.filter(({
    checked,
    isWildcard
  }) => checked === 'off' && isWildcard), 'title');
  return {
    includedItems,
    excludedItems,
    includedWildcards,
    excludedWildcards
  };
};
const getWildcardLabel = wildcard => {
  return _i18n.i18n.translate('xpack.ux.urlFilter.wildcard', {
    defaultMessage: 'Use wildcard *{wildcard}*',
    values: {
      wildcard
    }
  });
};
function URLSearch({
  onChange: onFilterChange,
  updateSearchTerm
}) {
  var _data$total;
  const {
    uxUiFilters: {
      transactionUrl,
      transactionUrlExcluded
    },
    urlParams
  } = (0, _use_url_params.useLegacyUrlParams)();
  const {
    searchTerm,
    percentile
  } = urlParams;
  const [popoverIsOpen, setPopoverIsOpen] = (0, _react.useState)(false);
  const [searchValue, setSearchValue] = (0, _react.useState)('');
  const [items, setItems] = (0, _react.useState)([]);
  const {
    data,
    loading
  } = (0, _use_url_search.useUrlSearch)({
    query: searchValue,
    popoverIsOpen
  });
  (0, _react.useEffect)(() => {
    var _data$items;
    const newItems = formatOptions((_data$items = data === null || data === void 0 ? void 0 : data.items) !== null && _data$items !== void 0 ? _data$items : [], transactionUrl, transactionUrlExcluded, percentile);
    const wildCardLabel = searchValue || searchTerm;
    if (wildCardLabel) {
      newItems.unshift({
        label: getWildcardLabel(wildCardLabel),
        title: wildCardLabel,
        isWildcard: true,
        checked: searchTerm ? 'on' : undefined
      });
    }
    setItems(newItems);
  }, [data, percentile, searchTerm, searchValue, transactionUrl, transactionUrlExcluded]);
  const onChange = updatedOptions => {
    setItems(updatedOptions.map(item => {
      const {
        isWildcard,
        checked
      } = item;
      if (isWildcard && checked === 'off') {
        return {
          ...item,
          checked: undefined
        };
      }
      return item;
    }));
  };
  const onInputChange = val => {
    setSearchValue(val);
  };
  const onApply = () => {
    const {
      includedItems,
      excludedItems
    } = processItems(items);
    onFilterChange(includedItems, excludedItems);
    updateSearchTerm(searchValue);
    setSearchValue('');
  };
  const hasChanged = () => {
    const {
      includedItems,
      excludedItems,
      includedWildcards
    } = processItems(items);
    let isWildcardChanged = includedWildcards.length > 0 && !searchTerm || includedWildcards.length === 0 && searchTerm;
    if (includedWildcards.length > 0) {
      isWildcardChanged = includedWildcards[0] !== searchTerm;
    }
    return isWildcardChanged || !(0, _lodash.isEqual)(includedItems.sort(), (transactionUrl !== null && transactionUrl !== void 0 ? transactionUrl : []).sort()) || !(0, _lodash.isEqual)(excludedItems.sort(), (transactionUrlExcluded !== null && transactionUrlExcluded !== void 0 ? transactionUrlExcluded : []).sort());
  };
  return /*#__PURE__*/_react.default.createElement(_public.SelectableUrlList, {
    loading: loading !== null && loading !== void 0 ? loading : true,
    onInputChange: onInputChange,
    data: {
      items,
      total: (_data$total = data === null || data === void 0 ? void 0 : data.total) !== null && _data$total !== void 0 ? _data$total : 0
    },
    onSelectionChange: onChange,
    searchValue: searchValue,
    popoverIsOpen: Boolean(popoverIsOpen),
    setPopoverIsOpen: setPopoverIsOpen,
    onSelectionApply: onApply,
    renderOption: _render_option.selectableRenderOptions,
    rowHeight: 64,
    hasChanged: () => Boolean(hasChanged())
  });
}