"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PageLoadDistribution = PageLoadDistribution;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _translations = require("../translations");
var _breakdown_filter = require("../breakdowns/breakdown_filter");
var _page_load_dist_chart = require("../charts/page_load_dist_chart");
var _reset_percentile_zoom = require("./reset_percentile_zoom");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function PageLoadDistribution() {
  const [percentileRange, setPercentileRange] = (0, _react.useState)({
    min: null,
    max: null
  });
  const [breakdown, setBreakdown] = (0, _react.useState)(null);
  const onPercentileChange = (0, _react.useCallback)((min, max) => {
    setPercentileRange({
      min,
      max
    });
  }, []);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-cy": "pageLoadDist"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _translations.I18LABELS.pageLoadDistribution))), /*#__PURE__*/_react.default.createElement(_reset_percentile_zoom.ResetPercentileZoom, {
    percentileRange: percentileRange,
    setPercentileRange: setPercentileRange
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      width: 170
    }
  }, /*#__PURE__*/_react.default.createElement(_breakdown_filter.BreakdownFilter, {
    selectedBreakdown: breakdown,
    onBreakdownChange: setBreakdown,
    dataTestSubj: 'pldBreakdownFilter'
  }))), /*#__PURE__*/_react.default.createElement(_page_load_dist_chart.PageLoadDistChart, {
    onPercentileChange: onPercentileChange,
    breakdown: breakdown
  }));
}