"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUxQuery = useUxQuery;
var _react = require("react");
var _use_url_params = require("../../../../context/url_params_context/use_url_params");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useUxQuery() {
  const {
    rangeId,
    urlParams,
    uxUiFilters
  } = (0, _use_url_params.useLegacyUrlParams)();
  const {
    start,
    end,
    searchTerm,
    percentile
  } = urlParams;
  const queryParams = (0, _react.useMemo)(() => {
    const {
      serviceName
    } = uxUiFilters;
    if (start && end && serviceName && percentile) {
      return {
        start,
        end,
        percentile: String(percentile),
        urlQuery: searchTerm || undefined,
        uiFilters: JSON.stringify(uxUiFilters)
      };
    }
    return null;

    // `rangeId` acts as a cache buster for stable date ranges like `Today`
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [start, end, searchTerm, percentile, uxUiFilters, rangeId]);
  return queryParams;
}