"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PageViewsChart = PageViewsChart;
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/observability-plugin/public");
var _eui = require("@elastic/eui");
var _public2 = require("@kbn/exploratory-view-plugin/public");
var _reactRouterDom = require("react-router-dom");
var _get_exp_view_filter = require("../../../../services/data/get_exp_view_filter");
var _use_url_params = require("../../../../context/url_params_context/use_url_params");
var _use_kibana_services = require("../../../../hooks/use_kibana_services");
var _use_data_view = require("../local_uifilters/use_data_view");
var _use_exp_view_attrs = require("./use_exp_view_attrs");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function PageViewsChart({
  breakdown
}) {
  const {
    dataViewTitle
  } = (0, _use_data_view.useDataView)();
  const history = (0, _reactRouterDom.useHistory)();
  const kibana = (0, _use_kibana_services.useKibanaServices)();
  const {
    ExploratoryViewEmbeddable
  } = kibana.exploratoryView;
  const {
    uxUiFilters,
    urlParams
  } = (0, _use_url_params.useLegacyUrlParams)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    reportDefinitions,
    time
  } = (0, _use_exp_view_attrs.useExpViewAttributes)();
  const allSeries = [{
    time,
    reportDefinitions,
    dataType: 'ux',
    name: 'ux-series-1',
    selectedMetricField: _public2.RECORDS_FIELD,
    breakdown: breakdown === null || breakdown === void 0 ? void 0 : breakdown.fieldName,
    color: euiTheme.colors.vis.euiColorVis1,
    filters: (0, _get_exp_view_filter.getExploratoryViewFilter)(uxUiFilters, urlParams)
  }];
  const onBrushEnd = (0, _react.useCallback)(({
    range
  }) => {
    if (!range) {
      return;
    }
    const [minX, maxX] = range;
    const rangeFrom = (0, _moment.default)(minX).toISOString();
    const rangeTo = (0, _moment.default)(maxX).toISOString();
    history.push({
      ...history.location,
      search: (0, _public.fromQuery)({
        ...(0, _public.toQuery)(history.location.search),
        rangeFrom,
        rangeTo
      })
    });
  }, [history]);
  if (!dataViewTitle) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(ExploratoryViewEmbeddable, {
    customHeight: '300px',
    attributes: allSeries,
    onBrushEnd: onBrushEnd,
    reportType: "kpi-over-time",
    isSingleMetric: true,
    axisTitlesVisibility: {
      x: false,
      yRight: true,
      yLeft: true
    },
    legendIsVisible: Boolean(breakdown)
  });
}