"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UrlDrilldownPlugin = void 0;
var _public = require("@kbn/ui-actions-enhanced-plugin/public");
var _public2 = require("@kbn/kibana-utils-plugin/public");
var _lib = require("./lib");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// eslint-disable-next-line @typescript-eslint/no-empty-interface

// eslint-disable-next-line @typescript-eslint/no-empty-interface

class UrlDrilldownPlugin {
  constructor(context) {
    this.context = context;
  }
  setup(core, plugins) {
    const startServices = (0, _public2.createStartServicesGetter)(core.getStartServices);
    plugins.uiActionsEnhanced.registerDrilldown(new _lib.UrlDrilldown({
      externalUrl: core.http.externalUrl,
      getGlobalScope: (0, _public.urlDrilldownGlobalScopeProvider)({
        core
      }),
      navigateToUrl: url => core.getStartServices().then(([{
        application
      }]) => application.navigateToUrl(url)),
      getSyntaxHelpDocsLink: () => startServices().core.docLinks.links.dashboard.urlDrilldownTemplateSyntax,
      getVariablesHelpDocsLink: () => startServices().core.docLinks.links.dashboard.urlDrilldownVariables,
      settings: core.settings,
      theme: () => startServices().core.theme
    }));
    return {};
  }
  start(core, plugins) {
    return {};
  }
  stop() {}
}
exports.UrlDrilldownPlugin = UrlDrilldownPlugin;