"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatusBadge = void 0;
exports.colorFromStatus = colorFromStatus;
exports.textFromStatus = textFromStatus;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function colorFromStatus(color, status) {
  switch (status) {
    case 'succeeded':
      return color.success;
    case 'failed':
      return color.danger;
    default:
      return 'default';
  }
}
function textFromStatus(status) {
  switch (status) {
    case 'succeeded':
      return _i18n.i18n.translate('xpack.uptime.synthetics.statusBadge.succeededMessage', {
        defaultMessage: 'Succeeded'
      });
    case 'failed':
      return _i18n.i18n.translate('xpack.uptime.synthetics.statusBadge.failedMessage', {
        defaultMessage: 'Failed'
      });
    case 'skipped':
      return _i18n.i18n.translate('xpack.uptime.synthetics.statusBadge.skippedMessage', {
        defaultMessage: 'Skipped'
      });
    default:
      return null;
  }
}
const StatusBadge = ({
  status,
  stepNo,
  isMobile
}) => {
  const theme = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, !isMobile && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    className: "eui-textNoWrap"
  }, /*#__PURE__*/_react.default.createElement("strong", null, stepNo, "."))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: colorFromStatus({
      danger: theme.euiTheme.colors.danger,
      success: theme.euiTheme.colors.success
    }, status)
  }, textFromStatus(status))));
};
exports.StatusBadge = StatusBadge;