"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStdErrorLogs = void 0;
var _reactRedux = require("react-redux");
var _public = require("@kbn/observability-shared-plugin/public");
var _selectors = require("../../../state/selectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useStdErrorLogs = ({
  monitorId,
  checkGroup
}) => {
  var _data$hits$hits$map;
  const {
    settings
  } = (0, _reactRedux.useSelector)(_selectors.selectDynamicSettings);
  const {
    data,
    loading
  } = (0, _public.useEsSearch)((0, _public.createEsParams)({
    index: !monitorId && !checkGroup ? '' : settings === null || settings === void 0 ? void 0 : settings.heartbeatIndices,
    size: 1000,
    query: {
      bool: {
        filter: [{
          term: {
            'synthetics.type': 'stderr'
          }
        }, ...(monitorId ? [{
          term: {
            'monitor.id': monitorId
          }
        }] : []), ...(checkGroup ? [{
          term: {
            'monitor.check_group': checkGroup
          }
        }] : [])]
      }
    }
  }), [settings === null || settings === void 0 ? void 0 : settings.heartbeatIndices], {
    name: 'getStdErrLogs'
  });
  return {
    items: (_data$hits$hits$map = data === null || data === void 0 ? void 0 : data.hits.hits.map(hit => ({
      ...hit._source,
      id: hit._id
    }))) !== null && _data$hits$hits$map !== void 0 ? _data$hits$hits$map : [],
    loading
  };
};
exports.useStdErrorLogs = useStdErrorLogs;