"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useQueryBar = exports.SyntaxType = exports.DEBOUNCE_INTERVAL = void 0;
var _react = require("react");
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _reactRedux = require("react-redux");
var _public = require("@kbn/kibana-react-plugin/public");
var _hooks = require("../../../hooks");
var _actions = require("../../../state/actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let SyntaxType = exports.SyntaxType = /*#__PURE__*/function (SyntaxType) {
  SyntaxType["text"] = "text";
  SyntaxType["kuery"] = "kuery";
  return SyntaxType;
}({});
const SYNTAX_STORAGE = 'uptime:queryBarSyntax';
const DEFAULT_QUERY_UPDATE_DEBOUNCE_INTERVAL = 800;
const DEBOUNCE_INTERVAL = exports.DEBOUNCE_INTERVAL = 250;

/**
 * Provides state management and automatic dispatching of a Query object.
 *
 * @returns {UseQueryBarUtils}
 */
const useQueryBar = () => {
  var _storage$get;
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    absoluteDateRangeStart,
    absoluteDateRangeEnd,
    ...params
  } = (0, _hooks.useGetUrlParams)();
  const {
    search,
    query: queryParam,
    filters: paramFilters,
    excludedFilters
  } = params;
  const {
    services: {
      storage
    }
  } = (0, _public.useKibana)();
  const [query, setQuery] = (0, _react.useState)(queryParam ? {
    query: queryParam,
    language: SyntaxType.text
  } : search ? {
    query: search,
    language: SyntaxType.kuery
  } : {
    query: '',
    language: (_storage$get = storage.get(SYNTAX_STORAGE)) !== null && _storage$get !== void 0 ? _storage$get : SyntaxType.text
  });
  const [, updateUrlParams] = (0, _hooks.useUrlParams)();
  const [esFilters, error] = (0, _hooks.useGenerateUpdatedKueryString)(query.language === SyntaxType.kuery ? query.query : undefined, paramFilters, excludedFilters);
  const setEsKueryFilters = (0, _react.useCallback)(esFiltersN => dispatch((0, _actions.setEsKueryString)(esFiltersN)), [dispatch]);
  const setEs = (0, _react.useCallback)(() => setEsKueryFilters(esFilters !== null && esFilters !== void 0 ? esFilters : ''), [esFilters, setEsKueryFilters]);
  const [, cancelEsKueryUpdate] = (0, _useDebounce.default)(setEs, DEFAULT_QUERY_UPDATE_DEBOUNCE_INTERVAL, [esFilters, setEsKueryFilters]);
  const handleQueryUpdate = (0, _react.useCallback)(() => {
    if (query.language === SyntaxType.text && queryParam !== query.query) {
      updateUrlParams({
        query: query.query
      });
    }
    if (query.language === SyntaxType.kuery && queryParam !== '') {
      updateUrlParams({
        query: ''
      });
    }
  }, [query.language, query.query, queryParam, updateUrlParams]);
  const [, cancelQueryUpdate] = (0, _useDebounce.default)(handleQueryUpdate, DEFAULT_QUERY_UPDATE_DEBOUNCE_INTERVAL, [query]);
  const submitImmediately = (0, _react.useCallback)(() => {
    cancelQueryUpdate();
    cancelEsKueryUpdate();
    handleQueryUpdate();
    setEs();
  }, [cancelEsKueryUpdate, cancelQueryUpdate, handleQueryUpdate, setEs]);
  (0, _useDebounce.default)(() => {
    if (query.language === SyntaxType.kuery && !error && esFilters && search !== query.query) {
      updateUrlParams({
        search: query.query
      });
    }
    if (query.language === SyntaxType.text && search !== '') {
      updateUrlParams({
        search: ''
      });
    }
    // this calls when it probably doesn't need to
    if (query.language === SyntaxType.kuery && query.query === '' && search !== '') {
      updateUrlParams({
        search: ''
      });
    }
  }, DEBOUNCE_INTERVAL, [esFilters, error]);
  return {
    query,
    setQuery,
    submitImmediately
  };
};
exports.useQueryBar = useQueryBar;