"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeprecateNoticeModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DeprecateNoticeModal = ({
  onCancel
}) => {
  const {
    application
  } = (0, _public.useKibana)().services;
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    titleProps: {
      id: modalTitleId
    },
    title: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, HEADER_TEXT, " ", /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "cheer"
    })),
    onCancel: onCancel,
    onConfirm: () => {
      application === null || application === void 0 ? void 0 : application.navigateToApp('synthetics');
    },
    confirmButtonText: GO_SYNTHETICS_TEXT,
    cancelButtonText: GO_BACK_TEXT
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.uptime.deprecateNoticeModal.description",
    defaultMessage: "The Elastic Synthetics integration is deprecated. Instead, you can now monitor endpoints, pages, and user journeys directly in the Synthetics app much more efficiently:"
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.uptime.deprecateNoticeModal.addPrivateLocations",
    defaultMessage: "Add private locations against your fleet policies"
  })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.uptime.deprecateNoticeModal.manageMonitors",
    defaultMessage: "Manage lightweight and browser monitors from a single place"
  })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.uptime.deprecateNoticeModal.elasticManagedLocations",
    defaultMessage: "Run monitors in multiple locations managed by Elastic, or from your own private locations"
  })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.uptime.deprecateNoticeModal.automateMonitors",
    defaultMessage: "Automate the creation of your monitors using project monitors"
  }))), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.uptime.deprecateNoticeModal.forMoreInformation",
    defaultMessage: "For more information, {docsLink}",
    values: {
      docsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "syntheticsDeprecateNoticeModalLink",
        target: "_blank",
        href: "https://www.elastic.co/guide/en/observability/current/monitor-uptime-synthetics.html"
      }, READ_DOCS_TEXT)
    }
  })));
};
exports.DeprecateNoticeModal = DeprecateNoticeModal;
const HEADER_TEXT = _i18n.i18n.translate('xpack.uptime.deprecateNoticeModal.headerText', {
  defaultMessage: 'Synthetic Monitoring is now available out of the box in Synthetics'
});
const GO_BACK_TEXT = _i18n.i18n.translate('xpack.uptime.deprecateNoticeModal.goBack', {
  defaultMessage: 'Go back'
});
const READ_DOCS_TEXT = _i18n.i18n.translate('xpack.uptime.deprecateNoticeModal.readDocs', {
  defaultMessage: 'read docs.'
});
const GO_SYNTHETICS_TEXT = _i18n.i18n.translate('xpack.uptime.deprecateNoticeModal.goToSynthetics', {
  defaultMessage: 'Go to Synthetics'
});