"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FingerprintCol = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledSpan = _styledComponents.default.span`
  margin-right: 8px;
`;
const FingerprintCol = ({
  cert
}) => {
  var _cert$sha1$toUpperCas, _cert$sha, _cert$sha256$toUpperC, _cert$sha2;
  const ShaComponent = ({
    text,
    val
  }) => {
    return /*#__PURE__*/_react.default.createElement(StyledSpan, {
      "data-test-subj": val,
      className: "eui-textNoWrap"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: val
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "observabilitySolutionShaComponentButton",
      flush: "right"
    }, text, ' ')), /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
      textToCopy: val !== null && val !== void 0 ? val : ''
    }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": "observabilitySolutionShaComponentButton",
      "aria-label": _translations.COPY_FINGERPRINT,
      onClick: copy,
      iconType: "copy",
      title: _translations.COPY_FINGERPRINT
    })));
  };
  return /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(ShaComponent, {
    text: "SHA 1",
    val: (_cert$sha1$toUpperCas = cert === null || cert === void 0 ? void 0 : (_cert$sha = cert.sha1) === null || _cert$sha === void 0 ? void 0 : _cert$sha.toUpperCase()) !== null && _cert$sha1$toUpperCas !== void 0 ? _cert$sha1$toUpperCas : ''
  }), /*#__PURE__*/_react.default.createElement(ShaComponent, {
    text: "SHA 256",
    val: (_cert$sha256$toUpperC = cert === null || cert === void 0 ? void 0 : (_cert$sha2 = cert.sha256) === null || _cert$sha2 === void 0 ? void 0 : _cert$sha2.toUpperCase()) !== null && _cert$sha256$toUpperC !== void 0 ? _cert$sha256$toUpperC : ''
  }));
};
exports.FingerprintCol = FingerprintCol;