"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResolutionTableCell = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const manualI18nTexts = {
  manualCellLabel: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.table.manualCellLabel', {
    defaultMessage: 'Manual'
  }),
  manualCellTooltipLabel: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.table.manualCellTooltipLabel', {
    defaultMessage: 'This issue needs to be resolved manually.'
  })
};
const automatedI18nTexts = {
  resolutionTypeCellLabel: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.table.automatedCellLabel', {
    defaultMessage: 'Automated'
  }),
  resolutionProgressCellLabel: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.table.automationInProgressCellLabel', {
    defaultMessage: 'Resolution in progress…'
  }),
  resolutionCompleteCellLabel: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.table.automationCompleteCellLabel', {
    defaultMessage: 'Resolved'
  }),
  resolutionFailedCellLabel: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.table.automationFailedCellLabel', {
    defaultMessage: 'Resolution failed'
  }),
  resolutionCellTooltipLabel: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.table.automatedCellTooltipLabel', {
    defaultMessage: 'This issue can be resolved automatically.'
  })
};
const markAsResolvedI18nTexts = {
  resolutionTypeCellLabel: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.table.markAsResolvedCellLabel', {
    defaultMessage: 'Mark as resolved'
  }),
  resolutionProgressCellLabel: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.table.markAsResolvedInProgressCellLabel', {
    defaultMessage: 'Marking as resolved…'
  }),
  resolutionCompleteCellLabel: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.table.markAsResolvedCompleteCellLabel', {
    defaultMessage: 'Marked as resolved'
  }),
  resolutionFailedCellLabel: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.table.markAsResolvedFailedCellLabel', {
    defaultMessage: 'Failed to mark as resolved'
  }),
  resolutionCellTooltipLabel: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.table.markAsResolvedCellTooltipLabel', {
    defaultMessage: 'This issue can be marked as resolved.'
  })
};
const ResolutionTableCell = ({
  deprecationId,
  isAutomated,
  canBeMarkedAsResolved,
  deprecationResolutionState
}) => {
  if (isAutomated || canBeMarkedAsResolved) {
    const resolutionI18nTexts = isAutomated ? automatedI18nTexts : markAsResolvedI18nTexts;
    const euiIconType = isAutomated ? 'indexSettings' : 'clickLeft';
    if ((deprecationResolutionState === null || deprecationResolutionState === void 0 ? void 0 : deprecationResolutionState.id) === deprecationId) {
      const {
        resolveDeprecationStatus
      } = deprecationResolutionState;
      switch (resolveDeprecationStatus) {
        case 'in_progress':
          return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
            gutterSize: "s",
            alignItems: "center",
            "data-test-subj": "resolutionStatusCell"
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: false
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
            size: "m"
          })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: false
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
            size: "s"
          }, resolutionI18nTexts.resolutionProgressCellLabel)));
        case 'fail':
          return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
            gutterSize: "s",
            alignItems: "center",
            "data-test-subj": "resolutionStatusCell"
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: false
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
            type: "warningFilled",
            color: "danger"
          })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: false
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
            size: "s"
          }, resolutionI18nTexts.resolutionFailedCellLabel)));
        case 'ok':
        default:
          return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
            gutterSize: "s",
            alignItems: "center",
            "data-test-subj": "resolutionStatusCell"
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: false
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
            type: "checkInCircleFilled",
            color: "success"
          })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: false
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
            size: "s"
          }, resolutionI18nTexts.resolutionCompleteCellLabel)));
      }
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: resolutionI18nTexts.resolutionCellTooltipLabel
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      tabIndex: 0,
      gutterSize: "s",
      alignItems: "center",
      "data-test-subj": "resolutionStatusCell"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: euiIconType
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, resolutionI18nTexts.resolutionTypeCellLabel))));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: manualI18nTexts.manualCellTooltipLabel,
    "data-test-subj": "resolutionStatusCell"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    tabIndex: 0,
    size: "s",
    color: "subdued"
  }, manualI18nTexts.manualCellLabel));
};
exports.ResolutionTableCell = ResolutionTableCell;