"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HighlightField = HighlightField;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _hover_popover_action = require("./hover_popover_action");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const HighlightFieldDescription = (0, _sharedUxUtility.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./highlight_field_description'))));
function HighlightField({
  field,
  fieldMetadata,
  formattedValue,
  icon,
  label,
  useBadge = false,
  value,
  children,
  truncate,
  ...props
}) {
  const hasFieldDescription = !!(fieldMetadata !== null && fieldMetadata !== void 0 && fieldMetadata.short);
  return formattedValue && value ? /*#__PURE__*/_react.default.createElement("div", props, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    alignItems: "center",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement("span", null, label)), hasFieldDescription ? /*#__PURE__*/_react.default.createElement(HighlightFieldDescription, {
    fieldMetadata: fieldMetadata
  }) : null), /*#__PURE__*/_react.default.createElement(_hover_popover_action.HoverActionPopover, {
    title: value,
    value: value,
    field: field,
    truncate: truncate
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    alignItems: "center",
    justifyContent: "flexStart",
    gutterSize: "xs"
  }, icon, useBadge ? /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    className: "eui-textTruncate",
    color: "hollow"
  }, formattedValue) : typeof children === 'function' ? children({
    content: /*#__PURE__*/_react.default.createElement(FormattedValue, {
      value: formattedValue
    })
  }) : /*#__PURE__*/_react.default.createElement(FormattedValue, {
    value: formattedValue
  })))) : null;
}
const FormattedValue = ({
  value
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  className: "eui-textTruncate",
  size: "s"
  // Value returned from formatFieldValue is always sanitized
  ,
  dangerouslySetInnerHTML: {
    __html: value
  }
});