"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.txtUrlTemplateSyntaxTestingHelpText = exports.txtUrlTemplateSyntaxHelpLinkText = exports.txtUrlTemplateOpenInNewTab = exports.txtUrlTemplateLabel = exports.txtUrlTemplateEncodeUrl = exports.txtUrlTemplateEncodeDescription = exports.txtUrlTemplateAdditionalOptions = exports.txtInvalidFormatErrorMessage = exports.txtEmptyErrorMessage = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const txtUrlTemplateLabel = exports.txtUrlTemplateLabel = _i18n.i18n.translate('uiActionsEnhanced.drilldowns.urlDrilldownCollectConfig.urlTemplateLabel', {
  defaultMessage: 'Enter URL'
});
const txtEmptyErrorMessage = exports.txtEmptyErrorMessage = _i18n.i18n.translate('uiActionsEnhanced.drilldowns.urlDrilldownCollectConfig.urlTemplateEmptyErrorMessage', {
  defaultMessage: 'URL template is required.'
});
const txtInvalidFormatErrorMessage = ({
  error,
  example
}) => _i18n.i18n.translate('uiActionsEnhanced.drilldowns.urlDrilldownCollectConfig.urlTemplateInvalidFormatErrorMessage', {
  defaultMessage: '{error} Example: {example}',
  values: {
    error,
    example
  }
});
exports.txtInvalidFormatErrorMessage = txtInvalidFormatErrorMessage;
const txtUrlTemplateSyntaxTestingHelpText = exports.txtUrlTemplateSyntaxTestingHelpText = _i18n.i18n.translate('uiActionsEnhanced.drilldowns.urlDrilldownCollectConfig.urlTemplateSyntaxTestingHelpText', {
  defaultMessage: 'To validate and test the URL template, save the configuration and use this drilldown from the panel.'
});
const txtUrlTemplateSyntaxHelpLinkText = exports.txtUrlTemplateSyntaxHelpLinkText = _i18n.i18n.translate('uiActionsEnhanced.drilldowns.urlDrilldownCollectConfig.urlTemplateSyntaxHelpLinkText', {
  defaultMessage: 'Syntax help'
});
const txtUrlTemplateOpenInNewTab = exports.txtUrlTemplateOpenInNewTab = _i18n.i18n.translate('uiActionsEnhanced.drilldowns.urlDrilldownCollectConfig.openInNewTabLabel', {
  defaultMessage: 'Open URL in new tab'
});
const txtUrlTemplateAdditionalOptions = exports.txtUrlTemplateAdditionalOptions = _i18n.i18n.translate('uiActionsEnhanced.drilldowns.urlDrilldownCollectConfig.additionalOptions', {
  defaultMessage: 'Additional options'
});
const txtUrlTemplateEncodeUrl = exports.txtUrlTemplateEncodeUrl = _i18n.i18n.translate('uiActionsEnhanced.drilldowns.urlDrilldownCollectConfig.encodeUrl', {
  defaultMessage: 'Encode URL'
});
const txtUrlTemplateEncodeDescription = exports.txtUrlTemplateEncodeDescription = _i18n.i18n.translate('uiActionsEnhanced.drilldowns.urlDrilldownCollectConfig.encodeDescription', {
  defaultMessage: 'If enabled, URL will be escaped using percent encoding'
});