"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.applyFormStateToTransformConfig = void 0;
var _lodash = require("lodash");
var _get_update_value = require("./get_update_value");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Takes in the form configuration and returns a request object suitable to be sent to the
// transform update API endpoint by iterating over `getUpdateValue()`.
// Once a user hits the update button, this function takes care of extracting the information
// necessary to create the update request. They take into account whether a field needs to
// be included at all in the request (for example, if it hadn't been changed).
// The code is also able to identify relationships/dependencies between form fields.
// For example, if the `pipeline` field was changed, it's necessary to make the `index`
// field part of the request, otherwise the update would fail.
const applyFormStateToTransformConfig = (config, formFields, formSections) =>
// Iterates over all form fields and only if necessary applies them to
// the request object used for updating the transform.
Object.keys(formFields).reduce((updateConfig, field) => (0, _lodash.merge)({
  ...updateConfig
}, (0, _get_update_value.getUpdateValue)(field, config, formFields, formSections)), {});
exports.applyFormStateToTransformConfig = applyFormStateToTransformConfig;