"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterEditorForm = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _codeEditor = require("@kbn/code-editor");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FilterEditorForm = ({
  config,
  onChange,
  isValid
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    height: 300,
    languageId: 'json',
    onChange: d => {
      onChange({
        config: d
      });
    },
    options: {
      automaticLayout: true,
      fontSize: 12,
      scrollBeyondLastLine: false,
      quickSuggestions: true,
      minimap: {
        enabled: false
      },
      wordWrap: 'on',
      wrappingIndent: 'indent'
    },
    value: config || ''
  }), isValid === false ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    iconType: "warning",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.transform.agg.filterEditorForm.jsonInvalidErrorMessage",
    defaultMessage: "JSON is invalid."
  }))) : null);
};
exports.FilterEditorForm = FilterEditorForm;