"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TelemetryNotifications = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _render_opt_in_status_notice_banner = require("./render_opt_in_status_notice_banner");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Helpers to the Telemetry banners spread through the code base in Welcome and Home landing pages.
 */
class TelemetryNotifications {
  constructor({
    http,
    overlays,
    telemetryService,
    telemetryConstants,
    ...startServices
  }) {
    (0, _defineProperty2.default)(this, "http", void 0);
    (0, _defineProperty2.default)(this, "overlays", void 0);
    (0, _defineProperty2.default)(this, "startServices", void 0);
    (0, _defineProperty2.default)(this, "telemetryConstants", void 0);
    (0, _defineProperty2.default)(this, "telemetryService", void 0);
    (0, _defineProperty2.default)(this, "optInStatusNoticeBannerId", void 0);
    /**
     * Should the opted-in banner be shown to the user?
     */
    (0, _defineProperty2.default)(this, "shouldShowOptInStatusNoticeBanner", () => {
      const userShouldSeeOptInNotice = this.telemetryService.getUserShouldSeeOptInNotice();
      const bannerOnScreen = typeof this.optInStatusNoticeBannerId !== 'undefined';
      return !bannerOnScreen && userShouldSeeOptInNotice;
    });
    /**
     * Renders the banner that claims the cluster is opted-in, and gives the option to opt-out.
     */
    (0, _defineProperty2.default)(this, "renderOptInStatusNoticeBanner", () => {
      const bannerId = (0, _render_opt_in_status_notice_banner.renderOptInStatusNoticeBanner)({
        http: this.http,
        onSeen: this.setOptInStatusNoticeSeen,
        overlays: this.overlays,
        telemetryConstants: this.telemetryConstants,
        telemetryService: this.telemetryService,
        ...this.startServices
      });
      this.optInStatusNoticeBannerId = bannerId;
    });
    /**
     * Clears the banner and stores the user's dismissal of the banner.
     */
    (0, _defineProperty2.default)(this, "setOptInStatusNoticeSeen", async () => {
      if (this.optInStatusNoticeBannerId) {
        this.overlays.banners.remove(this.optInStatusNoticeBannerId);
        this.optInStatusNoticeBannerId = undefined;
      }
      await this.telemetryService.setUserHasSeenNotice();
    });
    this.telemetryService = telemetryService;
    this.http = http;
    this.overlays = overlays;
    this.startServices = startServices;
    this.telemetryConstants = telemetryConstants;
  }
}
exports.TelemetryNotifications = TelemetryNotifications;