"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createAggregator = createAggregator;
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createAggregator({
  key,
  config,
  reset$,
  logger,
  events$,
  eventFilter,
  metricsAggregator
}) {
  if (reset$) {
    let lastResetTime = new Date();
    // Resets the aggregators either when the reset interval has passed or
    // a reset$ event is received
    (0, _rxjs.merge)((0, _rxjs.interval)(config.metrics_reset_interval).pipe((0, _rxjs.map)(() => {
      if (intervalHasPassedSince(lastResetTime, config.metrics_reset_interval)) {
        lastResetTime = new Date();
        if (logger) {
          logger.debug(`Resetting metrics due to reset interval expiration - ${lastResetTime.toISOString()}`);
        }
        return true;
      }
      return false;
    })), reset$.pipe((0, _rxjs.map)(value => {
      // keep track of the last time we reset due to collection
      lastResetTime = new Date();
      if (logger) {
        logger.debug(`Resetting metrics due to collection - ${lastResetTime.toISOString()}`);
      }
      return true;
    }))).subscribe(shouldReset => {
      if (shouldReset) {
        metricsAggregator.reset();
      }
    });
  }
  const taskEvents$ = events$.pipe((0, _rxjs.filter)(event => eventFilter(event)), (0, _rxjs.map)(event => {
    metricsAggregator.processTaskLifecycleEvent(event);
    return metricsAggregator.collect();
  }));
  return (0, _rxjs.combineLatest)([taskEvents$.pipe((0, _rxjs.startWith)(metricsAggregator.initialMetric()))]).pipe((0, _rxjs.map)(([value]) => {
    return {
      key,
      value
    };
  }));
}
function intervalHasPassedSince(date, intervalInMs) {
  const now = new Date().valueOf();
  return now - date.valueOf() > intervalInMs;
}