"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefaultCapacity = getDefaultCapacity;
var _config = require("../config");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Map instance size to desired capacity
const HEAP_TO_CAPACITY_MAP = [{
  minHeap: 0,
  maxHeap: 1,
  capacity: 10
}, {
  minHeap: 1,
  maxHeap: 2,
  capacity: 15
}, {
  minHeap: 2,
  maxHeap: 16,
  capacity: 25,
  backgroundTaskNodeOnly: false
}, {
  minHeap: 2,
  maxHeap: 16,
  capacity: 50,
  backgroundTaskNodeOnly: true
}];
function getDefaultCapacity({
  autoCalculateDefaultEchCapacity,
  claimStrategy,
  heapSizeLimit: heapSizeLimitInBytes,
  isCloud,
  isServerless,
  isBackgroundTaskNodeOnly
}) {
  // perform heap size based calculations only in cloud
  if (autoCalculateDefaultEchCapacity && isCloud && !isServerless && claimStrategy === _config.CLAIM_STRATEGY_MGET) {
    var _config$capacity;
    // convert bytes to GB
    const heapSizeLimitInGB = heapSizeLimitInBytes / 1e9;
    const config = HEAP_TO_CAPACITY_MAP.find(map => {
      return heapSizeLimitInGB > map.minHeap && heapSizeLimitInGB <= map.maxHeap && (map.backgroundTaskNodeOnly === undefined || isBackgroundTaskNodeOnly === map.backgroundTaskNodeOnly);
    });
    return (_config$capacity = config === null || config === void 0 ? void 0 : config.capacity) !== null && _config$capacity !== void 0 ? _config$capacity : _config.DEFAULT_CAPACITY;
  }
  return _config.DEFAULT_CAPACITY;
}