"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEnablement = useEnablement;
var _public = require("@kbn/kibana-react-plugin/public");
var _react = require("react");
var _reactRedux = require("react-redux");
var _state = require("../state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useEnablement() {
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    application
  } = (0, _public.useKibana)().services;
  const {
    loading,
    error,
    enablement
  } = (0, _reactRedux.useSelector)(_state.selectSyntheticsEnablement);
  (0, _react.useEffect)(() => {
    if (!enablement && !loading && !error) {
      dispatch((0, _state.getSyntheticsEnablement)());
    }
  }, [dispatch, enablement, error, loading]);
  (0, _react.useEffect)(() => {
    if (!(enablement !== null && enablement !== void 0 && enablement.canEnable) && !(enablement !== null && enablement !== void 0 && enablement.isEnabled) && !loading && enablement) {
      application === null || application === void 0 ? void 0 : application.navigateToApp('synthetics', {
        path: '/monitors'
      });
    }
  }, [application, enablement, loading]);
  return {
    areApiKeysEnabled: enablement === null || enablement === void 0 ? void 0 : enablement.areApiKeysEnabled,
    canManageApiKeys: enablement === null || enablement === void 0 ? void 0 : enablement.canManageApiKeys,
    canEnable: enablement === null || enablement === void 0 ? void 0 : enablement.canEnable,
    isEnabled: enablement === null || enablement === void 0 ? void 0 : enablement.isEnabled,
    isServiceAllowed: Boolean(enablement === null || enablement === void 0 ? void 0 : enablement.isServiceAllowed),
    invalidApiKeyError: enablement ? !Boolean(enablement === null || enablement === void 0 ? void 0 : enablement.isValidApiKey) : false,
    error,
    loading
  };
}