"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddParamFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/security-plugin/public");
var _eui = require("@elastic/eui");
var _reactHookForm = require("react-hook-form");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _i18n = require("@kbn/i18n");
var _reactRedux = require("react-redux");
var _lodash = require("lodash");
var _permissions = require("../../common/components/permissions");
var _global_params = require("../../../state/global_params");
var _use_form_wrapped = require("../../../../../hooks/use_form_wrapped");
var _add_param_form = require("./add_param_form");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AddParamFlyout = ({
  items,
  isEditingItem,
  setIsEditingItem
}) => {
  var _application$capabili;
  const [isFlyoutVisible, setIsFlyoutVisible] = (0, _react.useState)(false);
  const {
    id,
    ...dataToSave
  } = isEditingItem !== null && isEditingItem !== void 0 ? isEditingItem : {};
  const form = (0, _use_form_wrapped.useFormWrapped)({
    mode: 'onSubmit',
    reValidateMode: 'onChange',
    shouldFocusError: true,
    defaultValues: dataToSave !== null && dataToSave !== void 0 ? dataToSave : {
      key: '',
      tags: [],
      description: '',
      value: ''
    }
  });
  const closeFlyout = (0, _react.useCallback)(() => {
    setIsFlyoutVisible(false);
    setIsEditingItem(null);
    form.reset({
      key: '',
      tags: [],
      description: '',
      value: ''
    });
    // no need to add form value, it keeps changing on reset
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [setIsEditingItem]);
  const {
    application
  } = (0, _public2.useKibana)().services;
  const canSave = (_application$capabili = application === null || application === void 0 ? void 0 : application.capabilities.uptime.save) !== null && _application$capabili !== void 0 ? _application$capabili : false;
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    isSaving,
    savedData
  } = (0, _reactRedux.useSelector)(_global_params.selectGlobalParamState);
  const onSubmit = formData => {
    const {
      namespaces,
      ...paramRequest
    } = formData;
    const shareAcrossSpaces = namespaces === null || namespaces === void 0 ? void 0 : namespaces.includes(_public.ALL_SPACES_ID);
    const newParamData = {
      ...paramRequest
    };
    if (isEditingItem && id) {
      // omit value if it's empty
      if ((0, _lodash.isEmpty)(newParamData.value)) {
        // @ts-ignore this is a valid check
        delete newParamData.value;
      }
    }
    if (isEditingItem && id) {
      dispatch(_global_params.editGlobalParamAction.get({
        id,
        paramRequest
      }));
    } else {
      dispatch(_global_params.addNewGlobalParamAction.get({
        ...newParamData,
        share_across_spaces: shareAcrossSpaces
      }));
    }
  };
  (0, _react.useEffect)(() => {
    if (savedData && !isSaving) {
      closeFlyout();
      dispatch(_global_params.getGlobalParamAction.get());
    }
  }, [savedData, isSaving, closeFlyout, dispatch]);
  (0, _react.useEffect)(() => {
    if (isEditingItem) {
      const {
        id: _id,
        ...dataToEdit
      } = isEditingItem;
      setIsFlyoutVisible(true);
      form.reset(dataToEdit);
    }
    // no need to add form value, it keeps changing on reset
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [isEditingItem]);
  const {
    handleSubmit
  } = form;
  const flyoutTitleId = (0, _eui.useGeneratedHtmlId)();
  let flyout;
  if (isFlyoutVisible) {
    flyout = /*#__PURE__*/_react.default.createElement(_reactHookForm.FormProvider, form, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
      ownFocus: true,
      onClose: closeFlyout,
      size: "m",
      style: {
        minWidth: 500
      },
      "aria-labelledby": flyoutTitleId
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
      hasBorder: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "m"
    }, /*#__PURE__*/_react.default.createElement("h2", {
      id: flyoutTitleId
    }, isEditingItem ? EDIT_PARAM : CREATE_PARAM))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_add_param_form.AddParamForm, {
      items: items,
      isEditingItem: isEditingItem
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "syntheticsAddParamFlyoutButton",
      iconType: "cross",
      onClick: closeFlyout,
      flush: "left"
    }, CLOSE_TABLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "syntheticsAddParamFlyoutButton",
      onClick: handleSubmit(onSubmit),
      fill: true,
      isLoading: isSaving
    }, SAVE_TABLE))))));
  }
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_permissions.NoPermissionsTooltip, {
    canEditSynthetics: canSave
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "syntheticsAddParamFlyoutButton",
    fill: true,
    iconType: "plusInCircleFilled",
    iconSide: "left",
    onClick: () => setIsFlyoutVisible(true),
    isDisabled: !canSave
  }, CREATE_PARAM)), flyout);
};
exports.AddParamFlyout = AddParamFlyout;
const CLOSE_TABLE = _i18n.i18n.translate('xpack.synthetics.settingsRoute.cancel', {
  defaultMessage: 'Close'
});
const CREATE_PARAM = _i18n.i18n.translate('xpack.synthetics.settingsRoute.createParam', {
  defaultMessage: 'Create Parameter'
});
const EDIT_PARAM = _i18n.i18n.translate('xpack.synthetics.settingsRoute.params.editLabel', {
  defaultMessage: 'Edit Parameter'
});
const SAVE_TABLE = _i18n.i18n.translate('xpack.synthetics.settingsRoute.save', {
  defaultMessage: 'Save'
});