"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useManagementLocator = useManagementLocator;
var _public = require("@kbn/kibana-react-plugin/public");
var _react = require("react");
var _contexts = require("../../../contexts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useManagementLocator(extraPath) {
  var _application$capabili, _application$capabili2;
  const [templatePath, setTemplatePath] = (0, _react.useState)(null);
  const {
    basePath
  } = (0, _contexts.useSyntheticsSettingsContext)();
  const {
    share,
    application
  } = (0, _public.useKibana)().services;
  const canManageIndices = !!((_application$capabili = application.capabilities.management) !== null && _application$capabili !== void 0 && (_application$capabili2 = _application$capabili.data) !== null && _application$capabili2 !== void 0 && _application$capabili2.index_management);
  (0, _react.useEffect)(() => {
    if (!canManageIndices) return;
    const managementLocator = share.url.locators.get('MANAGEMENT_APP_LOCATOR');
    managementLocator === null || managementLocator === void 0 ? void 0 : managementLocator.getLocation({
      sectionId: 'data',
      appId: 'index_management'
    }).then(({
      app,
      path
    }) => setTemplatePath(`${basePath}/app/${app}${path}${extraPath}`));
  }, [share.url.locators, basePath, setTemplatePath, canManageIndices, extraPath]);
  return templatePath;
}