"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DurationSparklines = void 0;
var _eui = require("@elastic/eui");
var _public = require("@kbn/exploratory-view-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _react = _interopRequireDefault(require("react"));
var _use_monitor_query_filters = require("../hooks/use_monitor_query_filters");
var _duration_panel = require("./duration_panel");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DurationSparklines = props => {
  const {
    services: {
      exploratoryView: {
        ExploratoryViewEmbeddable
      }
    }
  } = (0, _public2.useKibana)();
  const {
    queryIdFilter,
    locationFilter
  } = (0, _use_monitor_query_filters.useMonitorQueryFilters)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  if (!queryIdFilter) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(ExploratoryViewEmbeddable, {
    id: props.id,
    reportType: _public.ReportTypes.KPI,
    axisTitlesVisibility: {
      x: false,
      yRight: false,
      yLeft: false
    },
    legendIsVisible: false,
    hideTicks: true,
    attributes: [{
      seriesType: 'area',
      time: props,
      name: _duration_panel.MEDIAN_DURATION_LABEL,
      dataType: 'synthetics',
      selectedMetricField: 'monitor.duration.us',
      reportDefinitions: queryIdFilter,
      filters: locationFilter,
      color: euiTheme.colors.vis.euiColorVis1
    }]
  }));
};
exports.DurationSparklines = DurationSparklines;