"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FailedTestsCount = void 0;
var _public = require("@kbn/kibana-react-plugin/public");
var _react = _interopRequireDefault(require("react"));
var _failed_tests = require("./failed_tests");
var _use_monitor_query_filters = require("../hooks/use_monitor_query_filters");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FailedTestsCount = ({
  from,
  to,
  id
}) => {
  const {
    exploratoryView: {
      ExploratoryViewEmbeddable
    }
  } = (0, _public.useKibana)().services;
  const {
    queryIdFilter,
    locationFilter
  } = (0, _use_monitor_query_filters.useMonitorQueryFilters)();
  if (!queryIdFilter) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(ExploratoryViewEmbeddable, {
    id: id,
    reportType: "single-metric",
    attributes: [{
      time: {
        from,
        to
      },
      reportDefinitions: queryIdFilter,
      filters: locationFilter,
      dataType: 'synthetics',
      selectedMetricField: 'monitor_failed_tests',
      name: _failed_tests.FAILED_TESTS_LABEL
    }]
  });
};
exports.FailedTestsCount = FailedTestsCount;