"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorSpaces = exports.ALL_SPACES_LABEL = void 0;
exports.getUpdatedSpacesSelection = getUpdatedSpacesSelection;
var _reactHookForm = require("react-hook-form");
var _public = require("@kbn/kibana-react-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public2 = require("@kbn/security-plugin/public");
var _use_kibana_space = require("../../../../../hooks/use_kibana_space");
var _constants = require("../constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns the updated list of selected space ids based on the selection logic.
 * @param selectedIds Array of selected space ids
 * @param currentSpaceId The id of the current space
 * @param allSpacesId The id representing "All spaces"
 */
function getUpdatedSpacesSelection(selectedIds, currentSpaceId, allSpacesId) {
  if (allSpacesId && selectedIds.includes(allSpacesId)) {
    // Only return allSpacesId if selected, ignore all others including currentSpaceId
    return [allSpacesId];
  }
  // Remove allSpacesId if present (should only be present alone)
  const filtered = allSpacesId ? selectedIds.filter(id => id !== allSpacesId) : selectedIds;
  if (filtered.length === 0 && currentSpaceId) {
    return [currentSpaceId];
  }
  if (currentSpaceId && !filtered.includes(currentSpaceId)) {
    return [...filtered, currentSpaceId];
  }
  return filtered;
}
const MonitorSpaces = ({
  value,
  onChange,
  ...rest
}) => {
  var _services$spaces;
  const {
    space: currentSpace
  } = (0, _use_kibana_space.useKibanaSpace)();
  const {
    services
  } = (0, _public.useKibana)();
  const [spacesList, setSpacesList] = _react.default.useState([]);
  const data = (_services$spaces = services.spaces) === null || _services$spaces === void 0 ? void 0 : _services$spaces.ui.useSpaces();
  const {
    control,
    formState: {
      isSubmitted
    },
    trigger
  } = (0, _reactHookForm.useFormContext)();
  const {
    isTouched,
    error
  } = control.getFieldState(_constants.ConfigKey.KIBANA_SPACES);
  const showFieldInvalid = (isSubmitted || isTouched) && !!error;
  (0, _react.useEffect)(() => {
    if (data !== null && data !== void 0 && data.spacesDataPromise) {
      data.spacesDataPromise.then(spacesData => {
        setSpacesList([allSpacesOption, ...[...spacesData.spacesMap].map(([spaceId, dataS]) => ({
          id: spaceId,
          label: dataS.name
        }))]);
      });
    }
  }, [data]);

  // Ensure selected options always include the current space
  const selectedIds = _react.default.useMemo(() => {
    if (!currentSpace) {
      return value !== null && value !== void 0 ? value : [];
    }
    if (!value || value.length === 0) {
      return [currentSpace.id];
    }
    if (value.includes(_public2.ALL_SPACES_ID)) {
      // If "All spaces" is selected, return it alone
      return [_public2.ALL_SPACES_ID];
    }
    return value.includes(currentSpace.id) ? value : [...value, currentSpace.id];
  }, [value, currentSpace]);

  // Compute if "All spaces" is selected
  const isAllSpacesSelected = selectedIds.includes(_public2.ALL_SPACES_ID);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    fullWidth: true,
    isDisabled: rest.readOnly,
    "aria-label": SPACES_LABEL,
    placeholder: SPACES_LABEL,
    isInvalid: showFieldInvalid,
    onBlur: async () => {
      await trigger();
    },
    options: spacesList.map(option => isAllSpacesSelected && option.id !== _public2.ALL_SPACES_ID ? {
      ...option,
      disabled: true
    } : option),
    selectedOptions: spacesList.filter(({
      id
    }) => selectedIds.includes(id)),
    isClearable: true,
    onChange: selected => {
      const newSelectedIds = selected.map(option => option.id);
      const updatedIds = getUpdatedSpacesSelection(newSelectedIds, currentSpace === null || currentSpace === void 0 ? void 0 : currentSpace.id, allSpacesOption.id);
      onChange(updatedIds);
    }
  });
};
exports.MonitorSpaces = MonitorSpaces;
const ALL_SPACES_LABEL = exports.ALL_SPACES_LABEL = _i18n.i18n.translate('xpack.synthetics.spaceList.allSpacesLabel', {
  defaultMessage: `* All spaces`
});
const allSpacesOption = {
  id: _public2.ALL_SPACES_ID,
  label: ALL_SPACES_LABEL
};
const SPACES_LABEL = _i18n.i18n.translate('xpack.synthetics.privateLocation.spacesLabel', {
  defaultMessage: 'Spaces '
});