"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConditionFields = getConditionFields;
var _conditions = require("../conditions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getConditionFields(condition) {
  const fields = collectFields(condition);
  // deduplicate fields, if mapped as string and number, keep as number
  const uniqueFields = new Map();
  fields.forEach(field => {
    const existing = uniqueFields.get(field.name);
    if (existing === 'number') {
      return;
    }
    if (existing === 'string' && field.type === 'number') {
      uniqueFields.set(field.name, 'number');
      return;
    }
    uniqueFields.set(field.name, field.type);
  });
  return Array.from(uniqueFields).map(([name, type]) => ({
    name,
    type
  }));
}
function collectFields(condition) {
  if ((0, _conditions.isFilterCondition)(condition)) {
    return [{
      name: condition.field,
      type: getFieldTypeForFilterCondition(condition)
    }];
  }
  if ((0, _conditions.isAndCondition)(condition)) {
    return condition.and.flatMap(collectFields);
  }
  if ((0, _conditions.isOrCondition)(condition)) {
    return condition.or.flatMap(collectFields);
  }
  return [];
}
function getFieldTypeForFilterCondition(condition) {
  switch (condition.operator) {
    case 'gt':
    case 'gte':
    case 'lt':
    case 'lte':
      return 'number';
    case 'neq':
    case 'eq':
    case 'exists':
    case 'contains':
    case 'startsWith':
    case 'endsWith':
    case 'notExists':
      return 'string';
    default:
      return 'string';
  }
}