"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SecurityError = void 0;
var _status_error = require("./status_error");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class SecurityError extends _status_error.StatusError {
  constructor(message, options) {
    super(message, 403);
    this.name = 'SecurityError';
    if (options !== null && options !== void 0 && options.cause) {
      // Attach the cause to the error if provided (ES2022 standard)
      this.cause = options.cause;
    }
  }
}
exports.SecurityError = SecurityError;