"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStreamsPrivileges = useStreamsPrivileges;
var _public = require("@kbn/streams-plugin/public");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _managementSettingsIds = require("@kbn/management-settings-ids");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useStreamsPrivileges() {
  const {
    core: {
      application: {
        capabilities: {
          streams
        }
      },
      uiSettings
    },
    dependencies: {
      start: {
        licensing
      }
    }
  } = (0, _use_kibana.useKibana)();
  const license = (0, _useObservable.default)(licensing.license$);
  const uiEnabled = uiSettings.get(_managementSettingsIds.OBSERVABILITY_ENABLE_STREAMS_UI);
  const significantEventsEnabled = uiSettings.get(_managementSettingsIds.OBSERVABILITY_STREAMS_ENABLE_SIGNIFICANT_EVENTS);
  return {
    ui: streams,
    features: {
      ui: {
        enabled: uiEnabled
      },
      significantEvents: license && {
        enabled: significantEventsEnabled,
        available: significantEventsEnabled && license.hasAtLeast('enterprise')
      }
    }
  };
}