"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildDiscoverParams = buildDiscoverParams;
var _uuid = require("uuid");
var _streamsSchema = require("@kbn/streams-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function buildDiscoverParams(significantEvent, definition) {
  return {
    timeRange: {
      from: 'now-7d',
      to: 'now'
    },
    query: {
      query: significantEvent.query.kql.query,
      language: 'kuery'
    },
    dataViewSpec: {
      id: (0, _uuid.v4)(),
      title: (0, _streamsSchema.getIndexPatternsForStream)(definition).join(','),
      timeFieldName: '@timestamp'
    }
  };
}