"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PreviewPanel = PreviewPanel;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _asset_image = require("../../asset_image");
var _streams_app_search_bar = require("../../streams_app_search_bar");
var _preview_table = require("../preview_table");
var _preview_matches = require("./preview_matches");
var _stream_routing_state_machine = require("./state_management/stream_routing_state_machine");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function PreviewPanel() {
  const routingSnapshot = (0, _stream_routing_state_machine.useStreamsRoutingSelector)(snapshot => snapshot);
  let content;
  if (routingSnapshot.matches({
    ready: 'idle'
  })) {
    content = /*#__PURE__*/_react.default.createElement(IdlePanel, null);
  } else if (routingSnapshot.matches({
    ready: 'editingRule'
  }) || routingSnapshot.matches({
    ready: 'reorderingRules'
  })) {
    content = /*#__PURE__*/_react.default.createElement(EditingPanel, null);
  } else if (routingSnapshot.matches({
    ready: 'creatingNewRule'
  })) {
    content = /*#__PURE__*/_react.default.createElement(RuleCreationPanel, null);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    component: "span",
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "inspect"
  }), /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.streams.streamDetail.preview.header', {
    defaultMessage: 'Data Preview'
  }))), /*#__PURE__*/_react.default.createElement(_streams_app_search_bar.StreamsAppSearchBar, {
    showDatePicker: true
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, content));
}
const IdlePanel = () => /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
  icon: /*#__PURE__*/_react.default.createElement(_asset_image.AssetImage, {
    type: "yourPreviewWillAppearHere"
  }),
  titleSize: "s",
  title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.streams.streamDetail.preview.editPreviewMessageEmpty', {
    defaultMessage: 'Your preview will appear here'
  })),
  body: _i18n.i18n.translate('xpack.streams.streamDetail.preview.editPreviewMessageEmptyDescription', {
    defaultMessage: 'Create a new child stream to see what will be routed to it based on the conditions'
  })
});
const EditingPanel = () => /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
  icon: /*#__PURE__*/_react.default.createElement(_asset_image.AssetImage, null),
  titleSize: "s",
  title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.streams.streamDetail.preview.editPreviewMessage', {
    defaultMessage: 'Preview is not available while editing or reordering streams'
  })),
  body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.streams.streamDetail.preview.editPreviewMessageBody', {
    defaultMessage: 'Once you save your changes, the results of your conditions will appear here.'
  })), /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.streams.streamDetail.preview.editPreviewReorderingWarning', {
    defaultMessage: 'Additionally, you will not be able to edit existing streams while reordering them, you should save or cancel your changes first.'
  })))
});
const RuleCreationPanel = () => {
  const samplesSnapshot = (0, _stream_routing_state_machine.useStreamSamplesSelector)(snapshot => snapshot);
  const isLoadingDocuments = samplesSnapshot.matches({
    fetching: {
      documents: 'loading'
    }
  });
  const isUpdating = samplesSnapshot.matches('debouncingCondition') || samplesSnapshot.matches({
    fetching: {
      documents: 'loading'
    }
  });
  const {
    documents,
    documentsError,
    approximateMatchingPercentage,
    approximateMatchingPercentageError
  } = samplesSnapshot.context;
  const hasDocuments = !(0, _lodash.isEmpty)(documents);
  const isLoadingDocumentCounts = samplesSnapshot.matches({
    fetching: {
      documentCounts: 'loading'
    }
  });
  let content = null;
  if (isLoadingDocuments && !hasDocuments) {
    content = /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingLogo, {
        logo: "logoLogging",
        size: "xl"
      }),
      titleSize: "s",
      title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.streams.streamDetail.preview.loadingPreviewTitle', {
        defaultMessage: 'Loading routing preview'
      })),
      body: _i18n.i18n.translate('xpack.streams.streamDetail.preview.loadingPreviewBody', {
        defaultMessage: 'This may take a few moments depending on the complexity of the conditions and the amount of data'
      })
    });
  } else if (documentsError) {
    content = /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      icon: /*#__PURE__*/_react.default.createElement(_asset_image.AssetImage, {
        type: "noResults"
      }),
      color: "danger",
      titleSize: "s",
      title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.streams.streamDetail.preview.error', {
        defaultMessage: 'Error loading preview'
      })),
      body: documentsError.message
    });
  } else if (!hasDocuments) {
    content = /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      icon: /*#__PURE__*/_react.default.createElement(_asset_image.AssetImage, {
        type: "noResults"
      }),
      titleSize: "s",
      title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.streams.streamDetail.preview.empty', {
        defaultMessage: 'No documents to preview'
      }))
    });
  } else if (hasDocuments) {
    content = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_preview_matches.PreviewMatches, {
      approximateMatchingPercentage: approximateMatchingPercentage,
      error: approximateMatchingPercentageError,
      isLoading: isLoadingDocumentCounts
    })), /*#__PURE__*/_react.default.createElement(_preview_table.PreviewTable, {
      documents: documents
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isUpdating && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "accent",
    position: "absolute"
  }), content);
};