"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IngestionRate = IngestionRate;
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _chartsTheme = require("@kbn/charts-theme");
var _i18n = require("@kbn/i18n");
var _streamsSchema = require("@kbn/streams-schema");
var _lodash = require("lodash");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireDefault(require("react"));
var _use_timefilter = require("../../../hooks/use_timefilter");
var _streams_app_search_bar = require("../../streams_app_search_bar");
var _format_bytes = require("./helpers/format_bytes");
var _use_ilm_phases_color_and_description = require("./hooks/use_ilm_phases_color_and_description");
var _use_ingestion_rate = require("./hooks/use_ingestion_rate");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function IngestionRate({
  definition,
  stats,
  isLoadingStats
}) {
  const {
    timeState
  } = (0, _use_timefilter.useTimefilter)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: false,
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h5", null, _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.ingestionRatePanel', {
    defaultMessage: 'Ingestion rate'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.ingestionRatePanelTooltip', {
      defaultMessage: 'Approximate average. Interval adjusts dynamically based on the time range. Calculated using the average document size in the stream, multiplied with the number of documents in the time bucket.'
    }),
    position: "right"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_streams_app_search_bar.StreamsAppSearchBar, {
    showDatePicker: true
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    alignItems: "center",
    css: {
      width: '100%',
      minHeight: '250px'
    },
    direction: "column",
    gutterSize: "xs"
  }, (0, _streamsSchema.isIlmLifecycle)(definition.effective_lifecycle) ? /*#__PURE__*/_react.default.createElement(ChartBarSeries, {
    definition: definition,
    stats: stats,
    timeState: timeState,
    isLoadingStats: isLoadingStats
  }) : /*#__PURE__*/_react.default.createElement(ChartAreaSeries, {
    definition: definition,
    stats: stats,
    timeState: timeState,
    isLoadingStats: isLoadingStats
  })));
}
function ChartAreaSeries({
  definition,
  stats,
  timeState,
  isLoadingStats
}) {
  const {
    ingestionRate,
    isLoading: isLoadingIngestionRate,
    error: ingestionRateError
  } = (0, _use_ingestion_rate.useIngestionRate)({
    definition,
    stats,
    timeState
  });
  const chartBaseTheme = (0, _chartsTheme.useElasticChartsTheme)();
  return ingestionRateError ? 'Failed to load ingestion rate' : isLoadingStats || isLoadingIngestionRate || !ingestionRate ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, null) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: {
      height: 250
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    showLegend: false,
    baseTheme: chartBaseTheme
  }), /*#__PURE__*/_react.default.createElement(_charts.AreaSeries, {
    id: "ingestionRate",
    name: "Ingestion rate",
    data: ingestionRate.buckets,
    color: "#61A2FF"
    // Defaults to multi layer time axis as of Elastic Charts v70
    ,
    xScaleType: _charts.ScaleType.Time,
    xAccessor: 'key',
    yAccessors: ['value']
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "bottom-axis",
    position: "bottom",
    tickFormat: value => (0, _moment.default)(value).format('YYYY-MM-DD HH:mm:ss'),
    gridLine: {
      visible: true
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "left-axis",
    position: "left",
    tickFormat: value => (0, _format_bytes.formatBytes)(value),
    gridLine: {
      visible: true
    }
  })), /*#__PURE__*/_react.default.createElement(Legend, {
    interval: ingestionRate.interval
  }));
}
function ChartBarSeries({
  definition,
  stats,
  timeState,
  isLoadingStats
}) {
  const {
    ingestionRate,
    isLoading: isLoadingIngestionRate,
    error: ingestionRateError
  } = (0, _use_ingestion_rate.useIngestionRatePerTier)({
    definition,
    stats,
    timeState
  });
  const {
    ilmPhases
  } = (0, _use_ilm_phases_color_and_description.useIlmPhasesColorAndDescription)();
  const chartBaseTheme = (0, _chartsTheme.useElasticChartsTheme)();
  return ingestionRateError ? 'Failed to load ingestion rate' : isLoadingStats || isLoadingIngestionRate || !ingestionRate ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, null) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: {
      height: 250
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    showLegend: false,
    baseTheme: chartBaseTheme
  }), Object.entries(ingestionRate.buckets).map(([tier, buckets]) => /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
    id: `ingestionRate-${tier}`,
    key: `ingestionRate-${tier}`,
    name: (0, _lodash.capitalize)(tier),
    data: buckets,
    color: ilmPhases[tier].color
    // Defaults to multi layer time axis as of Elastic Charts v70
    ,
    xScaleType: _charts.ScaleType.Time,
    xAccessor: 'key',
    yAccessors: ['value'],
    stackAccessors: [0]
  })), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "bottom-axis",
    position: "bottom",
    tickFormat: value => (0, _moment.default)(value).format('YYYY-MM-DD HH:mm:ss'),
    gridLine: {
      visible: true
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "left-axis",
    position: "left",
    tickFormat: value => (0, _format_bytes.formatBytes)(value),
    gridLine: {
      visible: true
    }
  })), /*#__PURE__*/_react.default.createElement(Legend, {
    interval: ingestionRate.interval
  }));
}
function Legend({
  interval
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("b", null, _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.ingestionRateLegend', {
    defaultMessage: 'per {interval}',
    values: {
      interval
    }
  })))));
}