"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EcsRecommendation = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EcsRecommendationText = _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditor.ecsRecommendationText', {
  defaultMessage: 'ECS recommendation'
});
const UknownEcsFieldText = _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditor.uknownEcsFieldText', {
  defaultMessage: 'Not an ECS field'
});
const LoadingText = _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditor.ecsRecommendationLoadingText', {
  defaultMessage: 'Loading...'
});
const EcsRecommendation = ({
  recommendation,
  isLoading
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, `${EcsRecommendationText}: `, isLoading ? LoadingText : recommendation !== undefined ? recommendation : UknownEcsFieldText);
};
exports.EcsRecommendation = EcsRecommendation;