"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LinksList = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LinksList = ({
  editAction,
  errors,
  index,
  links,
  messageVariables
}) => {
  const areLinksInvalid = Array.isArray(errors.links) && errors.links.length > 0;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: "pagerDutyLinks",
    label: _i18n.i18n.translate('xpack.stackConnectors.components.pagerDuty.linksFieldLabel', {
      defaultMessage: 'Links'
    }),
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued"
    }, _translations.OPTIONAL_LABEL),
    isInvalid: areLinksInvalid,
    error: errors.links,
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    "data-test-subj": "linksList",
    gutterSize: "s"
  }, links && links.map((link, currentLinkIndex) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": `linksListItemRow-${currentLinkIndex}`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    key: `linksListItemRow-${currentLinkIndex}`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.stackConnectors.components.pagerDuty.linkTextFieldLabel', {
      defaultMessage: 'Label'
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_public.TextFieldWithMessageVariables, {
    index: index,
    editAction: (key, value, actionIndex) => {
      const newLinks = [...links];
      newLinks[currentLinkIndex] = {
        href: link.href,
        text: value
      };
      editAction('links', newLinks, actionIndex);
    },
    messageVariables: messageVariables,
    paramsProperty: 'linksText',
    inputTargetValue: link.text
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.stackConnectors.components.pagerDuty.linkURLFieldLabel', {
      defaultMessage: 'URL'
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_public.TextFieldWithMessageVariables, {
    index: index,
    editAction: (key, value, actionIndex) => {
      const newLinks = [...links];
      newLinks[currentLinkIndex] = {
        text: link.text,
        href: value
      };
      editAction('links', newLinks, actionIndex);
    },
    messageVariables: messageVariables,
    paramsProperty: 'linksHref',
    inputTargetValue: link.href
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    color: "danger",
    onClick: () => {
      links.splice(currentLinkIndex, 1);
      editAction('links', links, index);
    },
    iconType: "minusInCircle",
    css: {
      marginTop: 28
    },
    "data-test-subj": "pagerDutyRemoveLinkButton"
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "plusInCircle",
    onClick: () => editAction('links', links ? [...links, {
      href: '',
      text: ''
    }] : [{
      href: '',
      text: ''
    }], index),
    "data-test-subj": "pagerDutyAddLinkButton"
  }, _i18n.i18n.translate('xpack.stackConnectors.components.pagerDuty.addLinkButtonLabel', {
    defaultMessage: 'Add Link'
  }))))));
};
exports.LinksList = LinksList;