"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetDashboard = void 0;
var _react = require("react");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _deeplinksAnalytics = require("@kbn/deeplinks-analytics");
var _api = require("./api");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGetDashboard = ({
  connectorId,
  selectedProvider
}) => {
  const {
    share,
    http,
    notifications: {
      toasts
    },
    spaces
  } = (0, _public.useKibana)().services;
  const [spaceId, setSpaceId] = (0, _react.useState)(null);
  (0, _react.useEffect)(() => {
    let didCancel = false;
    if (spaces) {
      spaces.getActiveSpace().then(space => {
        if (!didCancel) setSpaceId(space.id);
      });
    }
    return () => {
      didCancel = true;
    };
  }, [spaces]);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [dashboardUrl, setDashboardUrl] = (0, _react.useState)(null);
  const [dashboardCheckComplete, setDashboardCheckComplete] = (0, _react.useState)(false);
  const abortCtrl = (0, _react.useRef)(new AbortController());
  const setUrl = (0, _react.useCallback)(dashboardId => {
    var _share$url$locators$g;
    const url = share === null || share === void 0 ? void 0 : (_share$url$locators$g = share.url.locators.get(_deeplinksAnalytics.DASHBOARD_APP_LOCATOR)) === null || _share$url$locators$g === void 0 ? void 0 : _share$url$locators$g.getRedirectUrl({
      query: {
        language: 'kuery',
        query: `kibana.saved_objects: { id  : ${connectorId} }`
      },
      dashboardId
    });
    setDashboardUrl(url !== null && url !== void 0 ? url : null);
  }, [connectorId, share]);
  (0, _react.useEffect)(() => {
    let didCancel = false;
    const fetchData = async dashboardId => {
      abortCtrl.current = new AbortController();
      if (!didCancel) setIsLoading(true);
      try {
        const res = await (0, _api.getDashboard)({
          http,
          signal: abortCtrl.current.signal,
          connectorId,
          dashboardId
        });
        if (!didCancel) {
          var _res$data;
          setDashboardCheckComplete(true);
          setIsLoading(false);
          if ((_res$data = res.data) !== null && _res$data !== void 0 && _res$data.available) {
            setUrl(dashboardId);
          }
          if (res.status && res.status === 'error') {
            var _res$serviceMessage;
            toasts.addDanger({
              title: i18n.GET_DASHBOARD_API_ERROR(selectedProvider),
              text: `${(_res$serviceMessage = res.serviceMessage) !== null && _res$serviceMessage !== void 0 ? _res$serviceMessage : res.message}`
            });
          }
        }
      } catch (error) {
        if (!didCancel) {
          setDashboardCheckComplete(true);
          setIsLoading(false);
          toasts.addDanger({
            title: i18n.GET_DASHBOARD_API_ERROR(selectedProvider),
            text: error.message
          });
        }
      }
    };
    if (spaceId != null && connectorId.length > 0 && !dashboardCheckComplete) {
      abortCtrl.current.abort();
      fetchData(getDashboardId(selectedProvider, spaceId));
    }
    return () => {
      didCancel = true;
      setIsLoading(false);
      abortCtrl.current.abort();
    };
  }, [connectorId, dashboardCheckComplete, dashboardUrl, http, selectedProvider, setUrl, spaceId, toasts]);
  return {
    isLoading,
    dashboardUrl
  };
};
exports.useGetDashboard = useGetDashboard;
const getDashboardId = (selectedProvider, spaceId) => {
  let ai = 'openai';
  if (selectedProvider.toLowerCase().includes('bedrock')) {
    ai = 'bedrock';
  } else if (selectedProvider.toLowerCase().includes('gemini')) {
    ai = 'gemini';
  }
  return `generative-ai-token-usage-${ai}-${spaceId}`;
};