"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SpaceCopyResultDetails = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _moment = _interopRequireDefault(require("moment"));
var _react2 = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _copy_status_indicator = require("./copy_status_indicator");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getSavedObjectLabel(type) {
  switch (type) {
    case 'index-pattern':
    case 'index-patterns':
    case 'indexPatterns':
      return 'index patterns';
    default:
      return type;
  }
}
const isAmbiguousConflictError = error => error.type === 'ambiguous_conflict';
const SpaceCopyResultDetails = props => {
  const {
    destinationMap,
    onDestinationMapChange,
    summarizedCopyResult
  } = props;
  const {
    objects
  } = summarizedCopyResult;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)`
        margin-top: ${euiTheme.size.s};
        padding-left: ${euiTheme.size.l};
      `
  }, objects.map((object, index) => {
    const {
      type,
      id,
      name,
      icon,
      conflict
    } = object;
    const pendingObjectRetry = props.retries.find(r => r.type === type && r.id === id);
    const isOverwritePending = Boolean(pendingObjectRetry === null || pendingObjectRetry === void 0 ? void 0 : pendingObjectRetry.overwrite);
    const switchProps = {
      show: conflict && !props.conflictResolutionInProgress,
      label: _i18n.i18n.translate('xpack.spaces.management.copyToSpace.copyDetail.overwriteSwitch', {
        defaultMessage: 'Overwrite?'
      }),
      onChange: ({
        target: {
          checked
        }
      }) => {
        const filtered = props.retries.filter(r => r.type !== type || r.id !== id);
        const {
          error
        } = conflict;
        if (!checked) {
          props.onRetriesChange(filtered);
          if (isAmbiguousConflictError(error)) {
            // reset the selection to the first entry
            const value = error.destinations[0].id;
            onDestinationMapChange(new Map(destinationMap.set(`${type}:${id}`, value)));
          }
        } else {
          const destinationId = isAmbiguousConflictError(error) ? destinationMap.get(`${type}:${id}`) : error.destinationId;
          const retry = {
            type,
            id,
            overwrite: true,
            ...(destinationId && {
              destinationId
            })
          };
          props.onRetriesChange([...filtered, retry]);
        }
      }
    };
    const selectProps = {
      options: conflict !== null && conflict !== void 0 && conflict.error && isAmbiguousConflictError(conflict.error) ? conflict.error.destinations.map(destination => {
        var _destination$title;
        const header = (_destination$title = destination.title) !== null && _destination$title !== void 0 ? _destination$title : `${type} [id=${destination.id}]`;
        const lastUpdated = destination.updatedAt ? (0, _moment.default)(destination.updatedAt).fromNow() : 'never';
        return {
          value: destination.id,
          inputDisplay: destination.id,
          dropdownDisplay: /*#__PURE__*/_react2.default.createElement(_react2.Fragment, null, /*#__PURE__*/_react2.default.createElement("strong", null, header), /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
            size: "s",
            color: "subdued"
          }, /*#__PURE__*/_react2.default.createElement("p", null, "ID: ", destination.id, /*#__PURE__*/_react2.default.createElement("br", null), "Last updated: ", lastUpdated)))
        };
      }) : [],
      onChange: value => {
        onDestinationMapChange(new Map(destinationMap.set(`${type}:${id}`, value)));
        const filtered = props.retries.filter(r => r.type !== type || r.id !== id);
        const retry = {
          type,
          id,
          overwrite: true,
          destinationId: value
        };
        props.onRetriesChange([...filtered, retry]);
      }
    };
    const childWrapperStyles = isOpen => (0, _react.css)`
          overflow: hidden;
          transform: translateZ(0);
          transition: height ${euiTheme.animation.normal} ${euiTheme.animation.resistance},
            ${euiTheme.animation.normal} ${euiTheme.animation.resistance};

          visibility: ${isOpen ? 'visible' : 'hidden'};
          opacity: ${isOpen ? 1 : 0};
          height: ${isOpen ? 'auto' : 0};
        `;
    return /*#__PURE__*/_react2.default.createElement(_react2.Fragment, {
      key: index
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      key: index,
      alignItems: "center",
      gutterSize: "s",
      css: (0, _react.css)`
                margin-bottom: ${euiTheme.size.xs};
              `
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiIconTip, {
      position: "top",
      content: getSavedObjectLabel(type),
      "aria-label": getSavedObjectLabel(type),
      type: icon,
      size: "s"
    })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      grow: 5,
      css: (0, _react.css)`
                  min-width: 0;
                `
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react2.default.createElement("p", {
      className: "eui-textTruncate",
      title: name
    }, name))), switchProps.show && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiSwitch, {
      label: switchProps.label,
      compressed: true,
      checked: isOverwritePending,
      onChange: switchProps.onChange,
      "data-test-subj": `cts-overwrite-conflict-${type}:${id}`
    })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react2.default.createElement("div", {
      className: "eui-textRight"
    }, /*#__PURE__*/_react2.default.createElement(_copy_status_indicator.CopyStatusIndicator, {
      summarizedCopyResult: props.summarizedCopyResult,
      object: object,
      pendingObjectRetry: pendingObjectRetry,
      conflictResolutionInProgress: props.conflictResolutionInProgress && isOverwritePending
    })))), /*#__PURE__*/_react2.default.createElement("div", {
      css: (0, _react.css)`
                margin-left: ${euiTheme.size.l};
              `
    }, /*#__PURE__*/_react2.default.createElement("div", {
      css: childWrapperStyles(selectProps.options.length > 0 && isOverwritePending)
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiSuperSelect, {
      options: selectProps.options,
      valueOfSelected: destinationMap.get(`${type}:${id}`),
      onChange: selectProps.onChange,
      prepend: _i18n.i18n.translate('xpack.spaces.management.copyToSpace.copyDetail.selectControlLabel', {
        defaultMessage: 'Object ID'
      }),
      hasDividers: true,
      fullWidth: true,
      compressed: true
    }))));
  }));
};
exports.SpaceCopyResultDetails = SpaceCopyResultDetails;