"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CopyToSpaceFlyoutFooter = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isResolvableError = ({
  error: {
    type
  }
}) => ['conflict', 'ambiguous_conflict', 'missing_references'].includes(type);
const isUnresolvableError = failure => !isResolvableError(failure);
const CopyToSpaceFlyoutFooter = props => {
  const {
    copyInProgress,
    conflictResolutionInProgress,
    initialCopyFinished,
    copyResult,
    retries
  } = props;
  let summarizedResults = {
    successCount: 0,
    pendingCount: 0,
    skippedCount: 0,
    errorCount: 0
  };
  if (copyResult) {
    summarizedResults = Object.entries(copyResult).reduce((acc, result) => {
      const [spaceId, spaceResult] = result;
      let successCount = 0;
      let pendingCount = 0;
      let skippedCount = 0;
      let errorCount = 0;
      if (spaceResult.success === true) {
        successCount = spaceResult.successfulImports.length;
      } else {
        const uniqueResolvableErrors = spaceResult.failedImports.filter(isResolvableError).reduce((set, {
          obj: {
            type,
            id
          }
        }) => set.add(`${type}:${id}`), new Set());
        pendingCount = (retries[spaceId] || []).length;
        skippedCount = uniqueResolvableErrors.size + spaceResult.successfulImports.length - pendingCount;
        errorCount = spaceResult.failedImports.filter(isUnresolvableError).length;
      }
      return {
        loading: false,
        successCount: acc.successCount + successCount,
        pendingCount: acc.pendingCount + pendingCount,
        skippedCount: acc.skippedCount + skippedCount,
        errorCount: acc.errorCount + errorCount
      };
    }, summarizedResults);
  }
  const getButton = () => {
    let actionButton;
    if (initialCopyFinished) {
      const hasPendingRetries = summarizedResults.pendingCount > 0;
      const buttonText = hasPendingRetries ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.spaces.management.copyToSpace.finishPendingOverwritesCopyToSpacesButton",
        defaultMessage: "Copy {overwriteCount} objects",
        values: {
          overwriteCount: summarizedResults.pendingCount
        }
      }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.spaces.management.copyToSpace.finishCopyToSpacesButton",
        defaultMessage: "Finish"
      });
      actionButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        fill: true,
        isLoading: conflictResolutionInProgress,
        "aria-live": "assertive",
        "aria-label": conflictResolutionInProgress ? _i18n.i18n.translate('xpack.spaces.management.copyToSpace.inProgressButtonLabel', {
          defaultMessage: 'Copy is in progress. Please wait.'
        }) : _i18n.i18n.translate('xpack.spaces.management.copyToSpace.finishedButtonLabel', {
          defaultMessage: 'Copy finished.'
        }),
        onClick: () => props.onCopyFinish(),
        "data-test-subj": "cts-finish-button"
      }, buttonText);
    } else {
      actionButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        fill: true,
        isLoading: copyInProgress,
        onClick: () => props.onCopyStart(),
        "data-test-subj": "cts-initiate-button",
        disabled: props.numberOfSelectedSpaces === 0 || copyInProgress
      }, props.numberOfSelectedSpaces > 0 ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.spaces.management.copyToSpace.copyToSpacesButton",
        defaultMessage: "Copy to {spaceCount} {spaceCount, plural, one {space} other {spaces}}",
        values: {
          spaceCount: props.numberOfSelectedSpaces
        }
      }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.spaces.management.copyToSpace.disabledCopyToSpacesButton",
        defaultMessage: "Copy"
      }));
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: () => props.onClose(),
      "data-test-subj": "cts-cancel-button",
      disabled:
      // Cannot cancel while the operation is in progress, or after some objects have already been created
      copyInProgress && !initialCopyFinished || conflictResolutionInProgress || summarizedResults.successCount > 0
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.spaces.management.copyToSpace.cancelButton",
      defaultMessage: "Cancel"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, actionButton));
  };
  if (!copyInProgress) {
    return getButton();
  }
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    "data-test-subj": `cts-summary-success-count`,
    title: summarizedResults.successCount,
    titleSize: "s",
    titleColor: initialCopyFinished ? 'success' : 'subdued',
    isLoading: !initialCopyFinished,
    textAlign: "center",
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.spaces.management.copyToSpaceFlyoutFooter.successCount",
      defaultMessage: "Copied"
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    "data-test-subj": `cts-summary-pending-count`,
    title: summarizedResults.pendingCount,
    titleSize: "s",
    titleColor: summarizedResults.pendingCount > 0 ? 'primary' : 'subdued',
    isLoading: !initialCopyFinished,
    textAlign: "center",
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.spaces.management.copyToSpaceFlyoutFooter.pendingCount",
      defaultMessage: "Pending"
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    "data-test-subj": `cts-summary-skipped-count`,
    title: summarizedResults.skippedCount,
    titleSize: "s",
    titleColor: summarizedResults.skippedCount > 0 ? 'primary' : 'subdued',
    isLoading: !initialCopyFinished,
    textAlign: "center",
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.spaces.management.copyToSpaceFlyoutFooter.skippedCount",
      defaultMessage: "Skipped"
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    "data-test-subj": `cts-summary-error-count`,
    title: summarizedResults.errorCount,
    titleSize: "s",
    titleColor: summarizedResults.errorCount > 0 ? 'danger' : 'subdued',
    isLoading: !initialCopyFinished,
    textAlign: "center",
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.spaces.management.copyToSpaceFlyoutFooter.errorCount",
      defaultMessage: "Errors"
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), getButton());
};
exports.CopyToSpaceFlyoutFooter = CopyToSpaceFlyoutFooter;