"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryDocumentsFlyout = QueryDocumentsFlyout;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _documents_table = require("./documents_table");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function QueryDocumentsFlyout({
  name,
  dataView,
  searchBarProps,
  onCloseFlyout
}) {
  const flyoutTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutResizable, {
    onClose: () => onCloseFlyout(),
    size: "1050px",
    minWidth: 500,
    maxWidth: 1200,
    "aria-labelledby": flyoutTitleId
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: flyoutTitleId
  }, _i18n.i18n.translate('xpack.slo.queryBuilder.h2.documentsLabel', {
    defaultMessage: 'Documents for {indexPattern}',
    values: {
      indexPattern: dataView.getIndexPattern()
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_documents_table.DocumentsTable, {
    dataView: dataView,
    searchBarProps: searchBarProps,
    name: name
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "o11yQueryBuilderCloseButton",
    onClick: () => onCloseFlyout()
  }, _i18n.i18n.translate('xpack.slo.queryBuilder.closeButtonLabel', {
    defaultMessage: 'Close'
  }))));
}