"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addSpaceIdToPath = addSpaceIdToPath;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function addSpaceIdToPath(basePath = '/', spaceId = '', requestedPath = '') {
  if (requestedPath && !requestedPath.startsWith('/')) {
    throw new Error(`path must start with a /`);
  }
  if (basePath.includes('/s/')) {
    // If the base path already contains a space identifier, remove it
    basePath = basePath.replace(/\/s\/[^/]+/, '');
  }
  const normalizedBasePath = basePath.endsWith('/') ? basePath.slice(0, -1) : basePath;
  if (spaceId && spaceId !== 'default') {
    return `${normalizedBasePath}/s/${spaceId}${requestedPath}`;
  }
  return `${normalizedBasePath}${requestedPath}` || '/';
}