"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LanguageGrid = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LanguageGrid = ({
  assetBasePath,
  languages,
  selectedLanguage,
  setSelectedLanguage
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const isLarge = (0, _eui.useIsWithinBreakpoints)(['l']);
  const isXLarge = (0, _eui.useIsWithinBreakpoints)(['xl']);
  const columns = isXLarge ? 3 : isLarge ? 2 : 1;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: columns,
    gutterSize: "s",
    "data-test-subj": "client-select-container"
  }, languages.map(language => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: language.id
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    borderRadius: "m",
    className: language.id === selectedLanguage ? 'serverlessSearchSelectClientPanelSelectedBorder' : 'serverlessSearchSelectClientPanelBorder',
    onClick: () => setSelectedLanguage(language),
    color: language.id === selectedLanguage ? 'primary' : 'plain',
    "data-test-subj": `${language.id}-client-panel`,
    "aria-label": _i18n.i18n.translate('xpack.serverlessSearch.languageGrid.selectButton.ariaLabel', {
      defaultMessage: 'Select "{client}" client',
      values: {
        client: language.id
      }
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
    alt: "",
    src: `${assetBasePath}/${language.iconType}`,
    height: euiTheme.size.l,
    width: euiTheme.size.l
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    textAlign: "left",
    color: language.id === selectedLanguage ? 'default' : 'subdued'
  }, /*#__PURE__*/_react.default.createElement("h5", null, language.name))))))));
};
exports.LanguageGrid = LanguageGrid;