"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.networkTopNFlowCount = exports.networkTopNFlow = void 0;
var _fp = require("lodash/fp");
var _constants = require("../../../../../../common/constants");
var _build_query = require("../../../../../utils/build_query");
var _helpers = require("./helpers");
var _queryTop_n_flow_network = require("./query.top_n_flow_network.dsl");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const networkTopNFlow = exports.networkTopNFlow = {
  buildDsl: options => {
    if (options.pagination && options.pagination.querySize >= _constants.DEFAULT_MAX_TABLE_QUERY_SIZE) {
      throw new Error(`No query size above ${_constants.DEFAULT_MAX_TABLE_QUERY_SIZE}`);
    }
    return (0, _queryTop_n_flow_network.buildTopNFlowQuery)(options);
  },
  parse: async (options, response) => {
    const {
      cursorStart,
      querySize
    } = options.pagination;
    const networkTopNFlowEdges = (0, _helpers.getTopNFlowEdges)(response, options);
    const edges = networkTopNFlowEdges.splice(cursorStart, querySize - cursorStart);
    const inspect = {
      dsl: [(0, _build_query.inspectStringifyObject)((0, _queryTop_n_flow_network.buildTopNFlowQuery)(options))]
    };
    return {
      ...response,
      inspect,
      edges
    };
  }
};
const networkTopNFlowCount = exports.networkTopNFlowCount = {
  buildDsl: options => (0, _queryTop_n_flow_network.buildTopNFlowCountQuery)(options),
  parse: async (options, response) => {
    const totalCount = (0, _fp.getOr)(0, 'rawResponse.aggregations.top_n_flow_count.value', response);
    const inspect = {
      dsl: [(0, _build_query.inspectStringifyObject)((0, _queryTop_n_flow_network.buildTopNFlowCountQuery)(options))]
    };
    return {
      ...response,
      inspect,
      totalCount
    };
  }
};