"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initRoutes = void 0;
var _fleet_integrations = require("../lib/detection_engine/fleet_integrations");
var _prebuilt_rules = require("../lib/detection_engine/prebuilt_rules");
var _rule_actions_legacy = require("../lib/detection_engine/rule_actions_legacy");
var _rule_exceptions = require("../lib/detection_engine/rule_exceptions");
var _rule_management = require("../lib/detection_engine/rule_management");
var _rule_monitoring = require("../lib/detection_engine/rule_monitoring");
var _rule_preview = require("../lib/detection_engine/rule_preview");
var _create_index_route = require("../lib/detection_engine/routes/index/create_index_route");
var _read_index_route = require("../lib/detection_engine/routes/index/read_index_route");
var _create_signals_migration_route = require("../lib/detection_engine/routes/signals/create_signals_migration_route");
var _delete_signals_migration_route = require("../lib/detection_engine/routes/signals/delete_signals_migration_route");
var _finalize_signals_migration_route = require("../lib/detection_engine/routes/signals/finalize_signals_migration_route");
var _get_signals_migration_status_route = require("../lib/detection_engine/routes/signals/get_signals_migration_status_route");
var _query_signals_route = require("../lib/detection_engine/routes/signals/query_signals_route");
var _open_close_signals_route = require("../lib/detection_engine/routes/signals/open_close_signals_route");
var _delete_index_route = require("../lib/detection_engine/routes/index/delete_index_route");
var _read_privileges_route = require("../lib/detection_engine/routes/privileges/read_privileges_route");
var _telemetry_detection_rules_preview_route = require("../lib/detection_engine/routes/telemetry/telemetry_detection_rules_preview_route");
var _read_alerts_index_exists_route = require("../lib/detection_engine/routes/index/read_alerts_index_exists_route");
var _resolver = require("../endpoint/routes/resolver");
var _workflow_insights = require("../endpoint/routes/workflow_insights");
var _register_routes = require("../lib/exceptions/api/register_routes");
var _routes = require("../lib/dashboards/routes");
var _routes2 = require("../lib/tags/routes");
var _set_alert_tags_route = require("../lib/detection_engine/routes/signals/set_alert_tags_route");
var _set_alert_assignees_route = require("../lib/detection_engine/routes/signals/set_alert_assignees_route");
var _suggest_user_profiles_route = require("../lib/detection_engine/routes/users/suggest_user_profiles_route");
var _routes3 = require("../lib/timeline/routes");
var _routes4 = require("../lib/security_integrations/cribl/routes");
var _register_entity_analytics_routes = require("../lib/entity_analytics/register_entity_analytics_routes");
var _routes5 = require("../lib/siem_migrations/routes");
var _routes6 = require("../lib/asset_inventory/routes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// eslint-disable-next-line no-restricted-imports

const initRoutes = (router, config, hasEncryptionKey, security, telemetrySender, ml, ruleDataService, logger, ruleDataClient, getStartServices, securityRuleTypeOptions, previewRuleDataClient, previewTelemetryReceiver, isServerless, docLinks, endpointContext) => {
  (0, _fleet_integrations.registerFleetIntegrationsRoutes)(router, logger);
  (0, _rule_actions_legacy.registerLegacyRuleActionsRoutes)(router, logger);
  (0, _prebuilt_rules.registerPrebuiltRulesRoutes)(router, logger);
  (0, _rule_exceptions.registerRuleExceptionsRoutes)(router);
  (0, _register_routes.registerManageExceptionsRoutes)(router);
  (0, _rule_management.registerRuleManagementRoutes)(router, config, ml, logger);
  (0, _rule_monitoring.registerRuleMonitoringRoutes)(router);
  (0, _rule_preview.registerRulePreviewRoutes)(router, config, ml, security, securityRuleTypeOptions, previewRuleDataClient, getStartServices, logger, isServerless);
  (0, _resolver.registerResolverRoutes)(router, getStartServices, config);
  (0, _routes3.registerTimelineRoutes)(router, config, getStartServices);

  // Detection Engine Signals routes that have the REST endpoints of /api/detection_engine/signals
  // POST /api/detection_engine/signals/status
  // Example usage can be found in security_solution/server/lib/detection_engine/scripts/signals
  (0, _open_close_signals_route.setSignalsStatusRoute)(router, logger, telemetrySender);
  (0, _set_alert_tags_route.setAlertTagsRoute)(router);
  (0, _set_alert_assignees_route.setAlertAssigneesRoute)(router);
  (0, _query_signals_route.querySignalsRoute)(router, ruleDataClient);
  (0, _get_signals_migration_status_route.getSignalsMigrationStatusRoute)(router, docLinks);
  (0, _create_signals_migration_route.createSignalsMigrationRoute)(router, docLinks);
  (0, _finalize_signals_migration_route.finalizeSignalsMigrationRoute)(router, ruleDataService, docLinks);
  (0, _delete_signals_migration_route.deleteSignalsMigrationRoute)(router, docLinks);
  (0, _suggest_user_profiles_route.suggestUserProfilesRoute)(router, getStartServices);

  // Detection Engine index routes that have the REST endpoints of /api/detection_engine/index
  // All REST index creation, policy management for spaces
  (0, _create_index_route.createIndexRoute)(router);
  (0, _read_index_route.readIndexRoute)(router, ruleDataService);
  (0, _read_alerts_index_exists_route.readAlertsIndexExistsRoute)(router);
  (0, _delete_index_route.deleteIndexRoute)(router);

  // Privileges API to get the generic user privileges
  (0, _read_privileges_route.readPrivilegesRoute)(router, hasEncryptionKey);

  // Dashboards
  (0, _routes.registerDashboardsRoutes)(router, logger);
  (0, _routes2.registerTagsRoutes)(router, logger);
  const {
    previewTelemetryUrlEnabled
  } = config.experimentalFeatures;
  if (previewTelemetryUrlEnabled) {
    // telemetry preview endpoint for e2e integration tests only at the moment.
    (0, _telemetry_detection_rules_preview_route.telemetryDetectionRulesPreviewRoute)(router, logger, previewTelemetryReceiver, telemetrySender);
  }
  (0, _register_entity_analytics_routes.registerEntityAnalyticsRoutes)({
    router,
    config,
    getStartServices,
    logger
  });
  (0, _routes5.registerSiemMigrationsRoutes)(router, config, logger);

  // Security Integrations
  (0, _routes4.getFleetManagedIndexTemplatesRoute)(router);
  (0, _workflow_insights.registerWorkflowInsightsRoutes)(router, config, endpointContext);
  (0, _routes6.registerAssetInventoryRoutes)({
    router,
    logger
  });
};
exports.initRoutes = initRoutes;