"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VERSIONS_BY_ENTITY_TYPE = exports.DEFAULT_SYNC_DELAY = exports.DEFAULT_LOOKBACK_PERIOD = exports.DEFAULT_FREQUENCY = exports.DEFAULT_FIELD_HISTORY_LENGTH = void 0;
var _entity_descriptions = require("./entity_descriptions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const VERSIONS_BY_ENTITY_TYPE = exports.VERSIONS_BY_ENTITY_TYPE = {
  host: _entity_descriptions.HOST_DEFINITION_VERSION,
  user: _entity_descriptions.USER_DEFINITION_VERSION,
  service: _entity_descriptions.SERVICE_DEFINITION_VERSION,
  generic: _entity_descriptions.GENERIC_DEFINITION_VERSION
};
const DEFAULT_FIELD_HISTORY_LENGTH = exports.DEFAULT_FIELD_HISTORY_LENGTH = 10;
const DEFAULT_SYNC_DELAY = exports.DEFAULT_SYNC_DELAY = '1m';
const DEFAULT_FREQUENCY = exports.DEFAULT_FREQUENCY = '1m';
const DEFAULT_LOOKBACK_PERIOD = exports.DEFAULT_LOOKBACK_PERIOD = '1d';