"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ML_SEARCH_ANOMALIES_DESCRIPTION = exports.FIND_THRESHOLD_BUCKETS_DESCRIPTION = exports.FIND_SOURCE_DOCUMENTS_REQUEST_DESCRIPTION = exports.FIND_NEW_TERMS_VALUES_DESCRIPTION = exports.FIND_NEW_TERMS_EVENTS_DESCRIPTION = exports.FIND_EVENTS_DESCRIPTION = exports.FIND_EVENTS_AFTER_CURSOR_DESCRIPTION = exports.FIND_ALL_NEW_TERMS_FIELDS_DESCRIPTION = exports.ESQL_SHARD_FAILURE_MESSAGE = exports.ESQL_SEARCH_REQUEST_DESCRIPTION = exports.ESQL_POLL_REQUEST_DESCRIPTION = exports.ESQL_DELETE_REQUEST_DESCRIPTION = exports.EQL_SHARD_FAILURE_MESSAGE = exports.EQL_SEARCH_REQUEST_DESCRIPTION = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ESQL_SEARCH_REQUEST_DESCRIPTION = exports.ESQL_SEARCH_REQUEST_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.esqlRuleType.esqlSearchRequestDescription', {
  defaultMessage: 'ES|QL request to find all matches'
});
const ESQL_POLL_REQUEST_DESCRIPTION = exports.ESQL_POLL_REQUEST_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.esqlRuleType.esqlPollRequestDescription', {
  defaultMessage: 'ES|QL request to poll for async search results'
});
const ESQL_DELETE_REQUEST_DESCRIPTION = exports.ESQL_DELETE_REQUEST_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.esqlRuleType.esqlDeleteRequestDescription', {
  defaultMessage: 'ES|QL request to delete async search query'
});
const FIND_SOURCE_DOCUMENTS_REQUEST_DESCRIPTION = exports.FIND_SOURCE_DOCUMENTS_REQUEST_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.esqlRuleType.findSourceDocumentsRequestDescription', {
  defaultMessage: 'Retrieve source documents when ES|QL query is not aggregable'
});
const EQL_SEARCH_REQUEST_DESCRIPTION = exports.EQL_SEARCH_REQUEST_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.esqlRuleType.eqlSearchRequestDescription', {
  defaultMessage: 'EQL request to find all matches'
});
const EQL_SHARD_FAILURE_MESSAGE = (isEqlSequenceQuery, shardFailuresMessage) => isEqlSequenceQuery ? _i18n.i18n.translate('xpack.securitySolution.detectionEngine.eqlSequenceRuleType.eqlShardFailures', {
  defaultMessage: `The EQL query failed to run successfully due to unavailable shards: {shardFailures}`,
  values: {
    shardFailures: shardFailuresMessage
  }
}) : _i18n.i18n.translate('xpack.securitySolution.detectionEngine.eqlEventRuleType.eqlShardFailures', {
  defaultMessage: `The EQL event query was only executed on the available shards. The query failed to run successfully on the following shards: {shardFailures}`,
  values: {
    shardFailures: shardFailuresMessage
  }
});
exports.EQL_SHARD_FAILURE_MESSAGE = EQL_SHARD_FAILURE_MESSAGE;
const ESQL_SHARD_FAILURE_MESSAGE = shardFailuresMessage => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.esqlRuleType.esqlShardFailures', {
  defaultMessage: `The ES|QL event query was only executed on the available shards. The query failed to run successfully on the following shards: {shardFailures}`,
  values: {
    shardFailures: shardFailuresMessage
  }
});
exports.ESQL_SHARD_FAILURE_MESSAGE = ESQL_SHARD_FAILURE_MESSAGE;
const FIND_THRESHOLD_BUCKETS_DESCRIPTION = afterBucket => afterBucket ? _i18n.i18n.translate('xpack.securitySolution.detectionEngine.esqlRuleType.findThresholdRuleBucketsAfterDescription', {
  defaultMessage: 'Find all terms that exceeds threshold value after {afterBucket}',
  values: {
    afterBucket
  }
}) : _i18n.i18n.translate('xpack.securitySolution.detectionEngine.esqlRuleType.findThresholdRuleBucketsDescription', {
  defaultMessage: 'Find all terms that exceeds threshold value'
});
exports.FIND_THRESHOLD_BUCKETS_DESCRIPTION = FIND_THRESHOLD_BUCKETS_DESCRIPTION;
const ML_SEARCH_ANOMALIES_DESCRIPTION = exports.ML_SEARCH_ANOMALIES_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.esqlRuleType.mlSearchAnomaliesRequestDescription', {
  defaultMessage: 'Find all anomalies'
});
const FIND_EVENTS_DESCRIPTION = exports.FIND_EVENTS_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.queryRuleType.findEventsDescription', {
  defaultMessage: 'Find events'
});
const FIND_EVENTS_AFTER_CURSOR_DESCRIPTION = cursor => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.queryRuleType.findEventsAfterCursorDescription', {
  defaultMessage: 'Find events after cursor {cursor}',
  values: {
    cursor
  }
});
exports.FIND_EVENTS_AFTER_CURSOR_DESCRIPTION = FIND_EVENTS_AFTER_CURSOR_DESCRIPTION;
const FIND_ALL_NEW_TERMS_FIELDS_DESCRIPTION = afterKey => afterKey ? _i18n.i18n.translate('xpack.securitySolution.detectionEngine.newTermsRuleType.findAllNewTermsFieldsAfterDescription', {
  defaultMessage: 'Find all values after {afterKey}',
  values: {
    afterKey
  }
}) : _i18n.i18n.translate('xpack.securitySolution.detectionEngine.newTermsRuleType.findAllNewTermsFieldsDescription', {
  defaultMessage: 'Find all values'
});
exports.FIND_ALL_NEW_TERMS_FIELDS_DESCRIPTION = FIND_ALL_NEW_TERMS_FIELDS_DESCRIPTION;
const FIND_NEW_TERMS_VALUES_DESCRIPTION = afterKey => afterKey ? _i18n.i18n.translate('xpack.securitySolution.detectionEngine.newTermsRuleType.findNewTermsValuesAfterDescription', {
  defaultMessage: 'Find new values after {afterKey}',
  values: {
    afterKey
  }
}) : _i18n.i18n.translate('xpack.securitySolution.detectionEngine.newTermsRuleType.findNewTermsValuesDescription', {
  defaultMessage: 'Find new values'
});
exports.FIND_NEW_TERMS_VALUES_DESCRIPTION = FIND_NEW_TERMS_VALUES_DESCRIPTION;
const FIND_NEW_TERMS_EVENTS_DESCRIPTION = afterKey => afterKey ? _i18n.i18n.translate('xpack.securitySolution.detectionEngine.newTermsRuleType.findNewTermsEventsAfterDescription', {
  defaultMessage: 'Find documents associated with new values after {afterKey}',
  values: {
    afterKey
  }
}) : _i18n.i18n.translate('xpack.securitySolution.detectionEngine.newTermsRuleType.findNewTermsEventsDescription', {
  defaultMessage: 'Find documents associated with new values'
});
exports.FIND_NEW_TERMS_EVENTS_DESCRIPTION = FIND_NEW_TERMS_EVENTS_DESCRIPTION;