"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ensureLatestRulesPackageInstalled = ensureLatestRulesPackageInstalled;
var _install_prebuilt_rules_package = require("./install_prebuilt_rules_package");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function ensureLatestRulesPackageInstalled(ruleAssetsClient, securityContext, logger) {
  logger.debug('ensureLatestRulesPackageInstalled: Fetching latest versions of prebuilt rule assets');
  let latestPrebuiltRules = await ruleAssetsClient.fetchLatestAssets();
  logger.debug(`ensureLatestRulesPackageInstalled: Fetching latest versions of prebuilt rule assets - done. Fetched assets: ${latestPrebuiltRules.length}.`);
  if (latestPrebuiltRules.length === 0) {
    // Seems no packages with prepackaged rules were installed, try to install the default rules package
    await (0, _install_prebuilt_rules_package.installPrebuiltRulesPackage)(securityContext, logger);
    logger.debug('ensureLatestRulesPackageInstalled: Re-fetching latest versions of prebuilt rule assets after package installation');
    latestPrebuiltRules = await ruleAssetsClient.fetchLatestAssets();
    logger.debug(`ensureLatestRulesPackageInstalled: Re-fetched latest versions of prebuilt rule assets after package installation - done. Fetched assets: ${latestPrebuiltRules.length}.`);
  }
  return latestPrebuiltRules;
}