"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.calculateRuleUpgradeInfo = void 0;
var _lodash = require("lodash");
var _prebuilt_rules = require("../../../../../../common/api/detection_engine/prebuilt_rules");
var _invariant = require("../../../../../../common/utils/invariant");
var _convert_prebuilt_rule_asset_to_rule_response = require("../../../rule_management/logic/detection_rules_client/converters/convert_prebuilt_rule_asset_to_rule_response");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const calculateRuleUpgradeInfo = results => {
  return results.map(result => {
    const {
      ruleDiff,
      ruleVersions
    } = result;
    const installedCurrentVersion = ruleVersions.input.current;
    const targetVersion = ruleVersions.input.target;
    const baseVersion = ruleVersions.input.base;
    (0, _invariant.invariant)(installedCurrentVersion != null, 'installedCurrentVersion not found');
    (0, _invariant.invariant)(targetVersion != null, 'targetVersion not found');
    const targetRule = {
      ...(0, _convert_prebuilt_rule_asset_to_rule_response.convertPrebuiltRuleAssetToRuleResponse)(targetVersion),
      id: installedCurrentVersion.id,
      revision: installedCurrentVersion.revision + 1,
      created_at: installedCurrentVersion.created_at,
      created_by: installedCurrentVersion.created_by,
      updated_at: new Date().toISOString(),
      updated_by: installedCurrentVersion.updated_by
    };
    return {
      id: installedCurrentVersion.id,
      rule_id: installedCurrentVersion.rule_id,
      revision: installedCurrentVersion.revision,
      version: installedCurrentVersion.version,
      current_rule: installedCurrentVersion,
      target_rule: targetRule,
      has_base_version: baseVersion !== undefined,
      diff: {
        fields: (0, _lodash.pickBy)(ruleDiff.fields, fieldDiff => fieldDiff.diff_outcome !== _prebuilt_rules.ThreeWayDiffOutcome.StockValueNoUpdate && fieldDiff.diff_outcome !== _prebuilt_rules.ThreeWayDiffOutcome.MissingBaseNoUpdate),
        num_fields_with_updates: ruleDiff.num_fields_with_updates,
        num_fields_with_conflicts: ruleDiff.num_fields_with_conflicts,
        num_fields_with_non_solvable_conflicts: ruleDiff.num_fields_with_non_solvable_conflicts
      }
    };
  });
};
exports.calculateRuleUpgradeInfo = calculateRuleUpgradeInfo;