"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCommonColumns = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _common_styles = require("./common_styles");
var _helpers = require("../helpers");
var _note_previews = require("../note_previews");
var i18n = _interopRequireWildcard(require("../translations"));
var _empty_value = require("../../../../common/components/empty_value");
var _formatted_date = require("../../../../common/components/formatted_date");
var _timeline = require("../../../../../common/api/timeline");
var _types = require("../../../../../common/types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LineClampTextContainer = _styledComponents.default.span`
  text-overflow: ellipsis;
  display: -webkit-box;
  -webkit-line-clamp: 5;
  -webkit-box-orient: vertical;
  overflow: hidden;
`;

/**
 * Returns the column definitions (passed as the `columns` prop to
 * `EuiBasicTable`) that are common to the compact `Open Timeline` modal view,
 * and the full view shown in the `All Timelines` view of the `Timelines` page
 */
const getCommonColumns = ({
  itemIdToExpandedNotesRowMap,
  onOpenTimeline,
  onToggleShowNotes,
  timelineType
}) => [{
  dataType: 'auto',
  isExpander: true,
  render: ({
    notes,
    savedObjectId
  }) => notes != null && notes.length > 0 && savedObjectId != null ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "expand-notes",
    onClick: () => itemIdToExpandedNotesRowMap[savedObjectId] != null ? onToggleShowNotes((0, _fp.omit)(savedObjectId, itemIdToExpandedNotesRowMap)) : onToggleShowNotes({
      ...itemIdToExpandedNotesRowMap,
      [savedObjectId]: /*#__PURE__*/_react.default.createElement(_note_previews.NotePreviews, {
        notes: notes,
        timelineId: _types.TimelineId.active
      })
    }),
    "aria-label": itemIdToExpandedNotesRowMap[savedObjectId] ? i18n.COLLAPSE : i18n.EXPAND,
    iconType: itemIdToExpandedNotesRowMap[savedObjectId] ? 'arrowDown' : 'arrowRight'
  }) : null,
  width: _common_styles.ACTION_COLUMN_WIDTH
}, {
  dataType: 'string',
  field: 'title',
  name: timelineType === _timeline.TimelineTypeEnum.default ? i18n.TIMELINE_NAME : i18n.TIMELINE_TEMPLATE_NAME,
  render: (title, timelineResult) => timelineResult.savedObjectId != null ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": `timeline-title-${timelineResult.savedObjectId}`,
    onClick: () => onOpenTimeline({
      duplicate: false,
      timelineId: `${timelineResult.savedObjectId}`
    })
  }, (0, _helpers.isUntitled)(timelineResult) ? i18n.UNTITLED_TIMELINE : /*#__PURE__*/_react.default.createElement(LineClampTextContainer, null, title)) : /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": `title-no-saved-object-id-${title || 'no-title'}`
  }, (0, _helpers.isUntitled)(timelineResult) ? i18n.UNTITLED_TIMELINE : title),
  sortable: false
}, {
  dataType: 'string',
  field: 'description',
  name: i18n.DESCRIPTION,
  render: description => /*#__PURE__*/_react.default.createElement(LineClampTextContainer, {
    "data-test-subj": "description"
  }, description != null && description.trim().length > 0 ? description : (0, _empty_value.getEmptyTagValue)()),
  sortable: false
}, {
  dataType: 'date',
  field: 'updated',
  name: i18n.LAST_MODIFIED,
  render: (date, timelineResult) => /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "updated"
  }, timelineResult.updated != null ? /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedRelativePreferenceDate, {
    value: date
  }) : (0, _empty_value.getEmptyTagValue)()),
  sortable: true
}];
exports.getCommonColumns = getCommonColumns;