"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatusBadge = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _constants = require("../../../../../common/siem_migrations/constants");
var _translation_results = require("../../utils/translation_results");
var _rule_migration = require("../../../../../common/siem_migrations/model/rule_migration.gen");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const statusTextWrapperClassName = (0, _css.css)`
  width: 100%;
  display: inline-grid;
`;
const StatusBadge = exports.StatusBadge = /*#__PURE__*/_react.default.memo(({
  migrationRule,
  'data-test-subj': dataTestSubj = 'translation-result'
}) => {
  var _migrationRule$elasti, _migrationRule$transl;
  const colors = (0, _translation_results.useResultVisColors)();
  // Installed
  if ((_migrationRule$elasti = migrationRule.elastic_rule) !== null && _migrationRule$elasti !== void 0 && _migrationRule$elasti.id) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: i18n.RULE_STATUS_INSTALLED
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "check",
      color: colors[_constants.RuleTranslationResult.FULL]
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      "data-test-subj": dataTestSubj,
      grow: false
    }, i18n.RULE_STATUS_INSTALLED)));
  }

  // Failed
  if (migrationRule.status === _rule_migration.RuleMigrationStatusEnum.failed) {
    var _migrationRule$commen;
    const tooltipMessage = (_migrationRule$commen = migrationRule.comments) !== null && _migrationRule$commen !== void 0 && _migrationRule$commen.length ? migrationRule.comments[0].message : i18n.RULE_STATUS_FAILED;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: tooltipMessage
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "warningFilled",
      color: "danger"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      "data-test-subj": dataTestSubj,
      grow: false
    }, i18n.RULE_STATUS_FAILED)));
  }
  const translationResult = (_migrationRule$transl = migrationRule.translation_result) !== null && _migrationRule$transl !== void 0 ? _migrationRule$transl : 'untranslatable';
  const displayValue = (0, _translation_results.convertTranslationResultIntoText)(translationResult);
  const color = colors[translationResult];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: displayValue
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: color,
    "data-test-subj": dataTestSubj
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: statusTextWrapperClassName
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "eui-textTruncate"
  }, displayValue))));
});
StatusBadge.displayName = 'StatusBadge';