"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createSeverityColumn = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../common/siem_migrations/constants");
var _severity_badge = require("../../../../common/components/severity_badge");
var _constants2 = require("./constants");
var i18n = _interopRequireWildcard(require("./translations"));
var _header = require("./header");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createSeverityColumn = () => {
  return {
    field: 'elastic_rule.severity',
    name: /*#__PURE__*/_react.default.createElement(_header.TableHeader, {
      title: i18n.COLUMN_SEVERITY,
      tooltipContent: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.siemMigrations.rules.tableColumn.severityTooltip",
        defaultMessage: "{title} If the severity cannot be inferred from the rule export data, the rule Severity will be set to the default: Low severity.",
        values: {
          title: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
            size: "s"
          }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement("b", null, i18n.COLUMN_SEVERITY), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
            margin: "s"
          })))
        }
      })
    }),
    render: (value, rule) => rule.status === _constants.SiemMigrationStatus.FAILED ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _constants2.COLUMN_EMPTY_VALUE) : /*#__PURE__*/_react.default.createElement(_severity_badge.SeverityBadge, {
      value: value
    }),
    sortable: true,
    truncateText: true,
    width: '12%'
  };
};
exports.createSeverityColumn = createSeverityColumn;