"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SIEM_MIGRATIONS_SELECT_MIGRATION_BUTTON_ID = exports.HeaderButtons = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SIEM_MIGRATIONS_SELECT_MIGRATION_BUTTON_ID = exports.SIEM_MIGRATIONS_SELECT_MIGRATION_BUTTON_ID = 'siemMigrationsSelectMigrationButton';
const migrationStatsToComboBoxOption = stats => ({
  value: stats.id,
  label: stats.name,
  'data-test-subj': `migrationSelectionOption-${stats.id}`
});
const HeaderButtons = exports.HeaderButtons = /*#__PURE__*/_react.default.memo(({
  ruleMigrationsStats,
  selectedMigrationId,
  onMigrationIdChange
}) => {
  const migrationOptions = (0, _react.useMemo)(() => ruleMigrationsStats.map(migrationStatsToComboBoxOption), [ruleMigrationsStats]);
  const selectedMigrationOption = (0, _react.useMemo)(() => {
    const stats = ruleMigrationsStats.find(({
      id
    }) => id === selectedMigrationId);
    return stats ? [migrationStatsToComboBoxOption(stats)] : [];
  }, [ruleMigrationsStats, selectedMigrationId]);
  const onChange = selected => {
    onMigrationIdChange(selected[0].value);
  };
  if (!ruleMigrationsStats.length) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: (0, _react2.css)`
            width: 400px;
          `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement("h6", null, i18n.SIEM_MIGRATIONS_OPTION_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    id: SIEM_MIGRATIONS_SELECT_MIGRATION_BUTTON_ID,
    "aria-label": i18n.SIEM_MIGRATIONS_OPTION_AREAL_LABEL,
    onChange: onChange,
    options: migrationOptions,
    selectedOptions: selectedMigrationOption,
    singleSelection: {
      asPlainText: true
    },
    isClearable: false,
    inputPopoverProps: {
      css: (0, _react2.css)`
                & .euiComboBox__inputWrap div {
                  inline-size: 100%;
                }
              `
    },
    fullWidth: true
  })));
});
HeaderButtons.displayName = 'HeaderButtons';