"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSendIsolateEndpointRequest = void 0;
var _reactQuery = require("@kbn/react-query");
var _endpoint_isolation = require("../../../common/lib/endpoint/endpoint_isolation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Create host isolation requests
 * @param customOptions
 */
const useSendIsolateEndpointRequest = customOptions => {
  return (0, _reactQuery.useMutation)(isolateData => {
    return (0, _endpoint_isolation.isolateHost)(isolateData);
  }, customOptions);
};
exports.useSendIsolateEndpointRequest = useSendIsolateEndpointRequest;